/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.ImprovedCatalogTypeArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.ImprovedGameModeArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.CatalogTypes;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.GeneratorTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.difficulty.Difficulties;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@Command(aliases={"create"}, basePermission={"nucleus.world.create.base"}, commandDescriptionKey="world.create", parentCommand=WorldCommand.class)
public class CreateWorldCommand
implements ICommandExecutor<CommandSource>,
IReloadableService.Reloadable {
    private final DataQuery uuidLeast = DataQuery.of((String[])new String[]{"SpongeData", "UUIDLeast"});
    private final DataQuery uuidMost = DataQuery.of((String[])new String[]{"SpongeData", "UUIDMost"});
    private final DataQuery levelName = DataQuery.of((String[])new String[]{"Data", "LevelName"});
    private final DataQuery toId = DataQuery.of((String[])new String[]{"SpongeData", "dimensionId"});
    private final String preset = "preset";
    private final String name = "name";
    private final String dimension = "dimension";
    private final String generator = "generator";
    private final String gamemode = "gamemode";
    private final String difficulty = "difficulty";
    private final String modifier = "modifier";
    private final String seed = "seed";
    @Nullable
    private Long worldBorderDefault;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.flags().valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"preset"), WorldArchetype.class, serviceCollection)), new String[]{"p", "-preset"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ExtendedDimensionArgument((Text)Text.of((String)"dimension"), serviceCollection.messageProvider())), new String[]{"d", "-dimension"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"generator"), CatalogTypes.GENERATOR_TYPE, serviceCollection)), new String[]{"g", "-generator"}).valueFlag((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"modifier"), CatalogTypes.WORLD_GENERATOR_MODIFIER, serviceCollection), new String[]{"m", "-modifier"}).valueFlag(GenericArguments.onlyOne((CommandElement)GenericArguments.longNum((Text)Text.of((String)"seed"))), new String[]{"s", "-seed"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedGameModeArgument((Text)Text.of((String)"gamemode"), serviceCollection)), new String[]{"-gm", "-gamemode"}).valueFlag(GenericArguments.onlyOne((CommandElement)new ImprovedCatalogTypeArgument((Text)Text.of((String)"difficulty"), CatalogTypes.DIFFICULTY, serviceCollection)), new String[]{"-di", "-difficulty"}).flag(new String[]{"n", "-nostructures"}).flag(new String[]{"i"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"l")), new String[]{"l", "-loadonstartup"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"k")), new String[]{"k", "-keepspawnloaded"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"c")), new String[]{"c", "-allowcommands"}).valueFlag(GenericArguments.bool((Text)Text.of((String)"b")), new String[]{"b", "-bonuschest"}).buildWith(GenericArguments.onlyOne((CommandElement)GenericArguments.string((Text)Text.of((String)"name"))))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WorldProperties worldProperties;
        boolean bonusChest;
        String nameInput = context.requireOne(this.name, String.class);
        Optional<DimensionType> dimensionInput = context.getOne(this.dimension, DimensionType.class);
        Optional<GeneratorType> generatorInput = context.getOne(this.generator, GeneratorType.class);
        Optional<GameMode> gamemodeInput = context.getOne(this.gamemode, GameMode.class);
        Optional<Difficulty> difficultyInput = context.getOne(this.difficulty, Difficulty.class);
        Collection<WorldGeneratorModifier> modifiers = context.getAll(this.modifier, WorldGeneratorModifier.class);
        Optional<Long> seedInput = context.getOne(this.seed, Long.class);
        boolean genStructures = !context.hasAny("n");
        boolean loadOnStartup = !context.hasAny("l") || context.getOne("l", Boolean.class).orElse(true) != false;
        boolean keepSpawnLoaded = !context.hasAny("k") || context.getOne("k", Boolean.class).orElse(true) != false;
        boolean allowCommands = !context.hasAny("c") || context.getOne("c", Boolean.class).orElse(true) != false;
        boolean bl = bonusChest = !context.hasAny("b") || context.getOne("b", Boolean.class).orElse(true) != false;
        if (Sponge.getServer().getAllWorldProperties().stream().anyMatch(x -> x.getWorldName().equalsIgnoreCase(nameInput))) {
            return context.errorResult("command.world.create.exists", nameInput);
        }
        Path worldPath = Sponge.getGame().getGameDirectory().resolve("world");
        Path worldDir = worldPath.resolve(nameInput);
        if (!context.hasAny("i") && Files.exists(worldDir, new LinkOption[0])) {
            context.errorResult("command.world.import.noexist", nameInput);
        }
        if (context.hasAny("i") && Files.exists(worldDir, new LinkOption[0])) {
            this.onImport(context, worldDir);
        }
        WorldArchetype.Builder worldSettingsBuilder = WorldArchetype.builder().enabled(true);
        if (context.hasAny(this.preset)) {
            WorldArchetype preset1 = context.requireOne(this.preset, WorldArchetype.class);
            worldSettingsBuilder.from((Object)preset1);
            dimensionInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).dimension(arg_0));
            generatorInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).generator(arg_0));
            gamemodeInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).gameMode(arg_0));
            difficultyInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).difficulty(arg_0));
            if (!modifiers.isEmpty()) {
                modifiers.addAll(preset1.getGeneratorModifiers());
                worldSettingsBuilder.generatorModifiers(modifiers.toArray(new WorldGeneratorModifier[0]));
            }
        } else {
            worldSettingsBuilder.dimension(dimensionInput.orElse(DimensionTypes.OVERWORLD)).generator(generatorInput.orElse(GeneratorTypes.DEFAULT)).gameMode(gamemodeInput.orElse(GameModes.SURVIVAL)).difficulty(difficultyInput.orElse(Difficulties.NORMAL));
            if (!modifiers.isEmpty()) {
                worldSettingsBuilder.generatorModifiers(modifiers.toArray(new WorldGeneratorModifier[0]));
            }
        }
        worldSettingsBuilder.loadsOnStartup(loadOnStartup).keepsSpawnLoaded(keepSpawnLoaded).usesMapFeatures(genStructures).commandsAllowed(allowCommands).generateBonusChest(bonusChest);
        seedInput.ifPresent(arg_0 -> ((WorldArchetype.Builder)worldSettingsBuilder).seed(arg_0));
        WorldArchetype wa = worldSettingsBuilder.build(nameInput.toLowerCase(), nameInput);
        context.sendMessage("command.world.create.begin", nameInput);
        context.sendMessage("command.world.create.newparams", wa.getDimensionType().getName(), wa.getGeneratorType().getName(), CreateWorldCommand.modifierString(context, modifiers), wa.getGameMode().getName(), wa.getDifficulty().getName());
        context.sendMessage("command.world.create.newparams2", String.valueOf(loadOnStartup), String.valueOf(keepSpawnLoaded), String.valueOf(genStructures), String.valueOf(allowCommands), String.valueOf(bonusChest));
        try {
            worldProperties = Sponge.getGame().getServer().createWorldProperties(nameInput, wa);
        }
        catch (IOException e) {
            e.printStackTrace();
            return context.errorResultLiteral(Text.of((Object[])new Object[]{TextColors.RED, e.getMessage()}));
        }
        if (this.worldBorderDefault != null && this.worldBorderDefault > 0L) {
            worldProperties.setWorldBorderDiameter((double)this.worldBorderDefault.longValue());
        }
        worldProperties.setDifficulty(wa.getDifficulty());
        if (!Sponge.getServer().saveWorldProperties(worldProperties)) {
            return context.errorResult("command.world.create.couldnotsave", nameInput);
        }
        Optional world = Sponge.getGame().getServer().loadWorld(worldProperties);
        if (world.isPresent()) {
            ((World)world.get()).getProperties().setDifficulty(wa.getDifficulty());
            context.sendMessage("command.world.create.success", nameInput);
            return context.successResult();
        }
        return context.errorResult("command.world.create.worldfailedtoload", nameInput);
    }

    private OutputStream getOutput(boolean gzip, Path file) throws IOException {
        OutputStream os = Files.newOutputStream(file, new OpenOption[0]);
        if (gzip) {
            return new GZIPOutputStream(os, true);
        }
        return os;
    }

    private void onImport(ICommandContext<? extends CommandSource> context, Path world) {
        OutputStream os;
        Throwable throwable;
        Object gzip;
        DataContainer dc;
        Throwable throwable2;
        InputStream is;
        boolean gz;
        Path level = world.resolve("level.dat");
        Path levelSponge = world.resolve("level_sponge.dat");
        if (Files.exists(level, new LinkOption[0])) {
            gz = false;
            try {
                try {
                    is = Files.newInputStream(level, StandardOpenOption.READ);
                    throwable2 = null;
                    try {
                        dc = DataFormats.NBT.readFrom(is);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (is != null) {
                            if (throwable2 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (EOFException ex) {
                    gzip = new GZIPInputStream(Files.newInputStream(level, StandardOpenOption.READ));
                    throwable = null;
                    try {
                        dc = DataFormats.NBT.readFrom((InputStream)gzip);
                        gz = true;
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (gzip != null) {
                            if (throwable != null) {
                                try {
                                    ((GZIPInputStream)gzip).close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                ((GZIPInputStream)gzip).close();
                            }
                        }
                    }
                }
                Files.copy(level, world.resolve("level.dat.nbak"), StandardCopyOption.REPLACE_EXISTING);
                dc.remove(this.levelName);
                os = this.getOutput(gz, level);
                gzip = null;
                try {
                    DataFormats.NBT.writeTo(os, (DataView)dc);
                    os.flush();
                }
                catch (Throwable throwable7) {
                    gzip = throwable7;
                    throw throwable7;
                }
                finally {
                    if (os != null) {
                        if (gzip != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable8) {
                                ((Throwable)gzip).addSuppressed(throwable8);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                context.getServiceCollection().logger().warn("Could not read the level.dat. Ignoring.");
            }
        }
        if (Files.exists(levelSponge, new LinkOption[0])) {
            gz = false;
            try {
                try {
                    is = Files.newInputStream(levelSponge, StandardOpenOption.READ);
                    gzip = null;
                    try {
                        dc = DataFormats.NBT.readFrom(is);
                    }
                    catch (Throwable throwable9) {
                        gzip = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (is != null) {
                            if (gzip != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable10) {
                                    ((Throwable)gzip).addSuppressed(throwable10);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (EOFException ex) {
                    gzip = new GZIPInputStream(Files.newInputStream(levelSponge, StandardOpenOption.READ));
                    throwable = null;
                    try {
                        dc = DataFormats.NBT.readFrom((InputStream)gzip);
                        gz = true;
                    }
                    catch (Throwable throwable11) {
                        throwable = throwable11;
                        throw throwable11;
                    }
                    finally {
                        if (gzip != null) {
                            if (throwable != null) {
                                try {
                                    ((GZIPInputStream)gzip).close();
                                }
                                catch (Throwable throwable12) {
                                    throwable.addSuppressed(throwable12);
                                }
                            } else {
                                ((GZIPInputStream)gzip).close();
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                context.getServiceCollection().logger().warn("Could not read the level_sponge.dat. Ignoring.");
                return;
            }
            dc.remove(this.toId);
            dc.remove(this.uuidLeast);
            dc.remove(this.uuidMost);
            try {
                Files.copy(levelSponge, world.resolve("level_sponge.dat.nbak"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
                context.getServiceCollection().logger().warn("Could not backup the level_sponge.dat. Ignoring.");
                return;
            }
            try {
                os = this.getOutput(gz, levelSponge);
                throwable2 = null;
                try {
                    DataFormats.NBT.writeTo(os, (DataView)dc);
                    os.flush();
                }
                catch (Throwable throwable13) {
                    throwable2 = throwable13;
                    throw throwable13;
                }
                finally {
                    if (os != null) {
                        if (throwable2 != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable14) {
                                throwable2.addSuppressed(throwable14);
                            }
                        } else {
                            os.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                context.getServiceCollection().logger().warn("Could not save the level_sponge.dat. Ignoring.");
            }
        }
    }

    static String modifierString(ICommandContext<? extends CommandSource> context, Collection<WorldGeneratorModifier> cw) {
        if (cw.isEmpty()) {
            return context.getMessageString("command.world.create.nomodifiers", new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        cw.forEach(x -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(x.getName());
        });
        return sb.toString();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.worldBorderDefault = serviceCollection.moduleDataProvider().getModuleConfig(WorldConfig.class).getWorldBorderDefault().orElse(null);
    }

    @NonnullByDefault
    public static class ExtendedDimensionArgument
    extends CommandElement {
        private final IMessageProviderService messageProviderService;
        private static HashMap<String, DimensionType> replacement = new HashMap<String, DimensionType>(){
            {
                this.put("dim0", DimensionTypes.OVERWORLD);
                this.put("dim-1", DimensionTypes.NETHER);
                this.put("dim1", DimensionTypes.THE_END);
            }
        };

        private ExtendedDimensionArgument(@Nullable Text key, IMessageProviderService messageProviderService) {
            super(key);
            this.messageProviderService = messageProviderService;
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            String arg = args.next();
            if (replacement.containsKey(arg.toLowerCase())) {
                return replacement.get(arg.toLowerCase());
            }
            String arg2 = arg;
            if (!arg2.contains(":")) {
                arg2 = "minecraft:" + arg2;
            }
            return Sponge.getRegistry().getType(DimensionType.class, arg2).orElseThrow(() -> args.createError(this.messageProviderService.getMessageFor(source, "args.dimensiontype.notfound", arg)));
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            List<String> ids = Sponge.getRegistry().getAllOf(DimensionType.class).stream().map(CatalogType::getId).collect(Collectors.toList());
            try {
                String a = args.peek();
                return ids.stream().filter(x -> x.startsWith(a)).collect(Collectors.toList());
            }
            catch (Exception e) {
                return ids;
            }
        }
    }
}

