/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.teleport;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.teleport.data.NucleusTeleportHelperFilters;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanner;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.core.config.SafeTeleportConfig;
import io.github.nucleuspowered.nucleus.modules.teleport.events.AboutToTeleportEvent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.INucleusTeleportService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

@Singleton
public class SafeTeleportService
implements INucleusTeleportService,
IReloadableService.Reloadable {
    private static final INucleusTeleportService.BorderDisableSession DUMMY = new INucleusTeleportService.BorderDisableSession(){};
    private SafeTeleportConfig config = new SafeTeleportConfig();

    @Inject
    public SafeTeleportService(PluginContainer pluginContainer, IReloadableService reloadableService) {
        Sponge.getServiceManager().setProvider((Object)pluginContainer, INucleusTeleportService.class, (Object)this);
        reloadableService.registerReloadable(this);
    }

    @Override
    public boolean setLocation(Player player, Location<World> location) {
        if (player.setLocation(location)) {
            player.setSpectatorTarget(null);
            return true;
        }
        return false;
    }

    @Override
    public TeleportResult teleportPlayerSmart(Player player, Transform<World> transform, boolean centreBlock, boolean safe, TeleportScanner scanner) {
        return this.teleportPlayerSmart(player, (Location<World>)transform.getLocation(), transform.getRotation(), centreBlock, safe, scanner);
    }

    @Override
    public TeleportResult teleportPlayerSmart(Player player, Location<World> location, boolean centreBlock, boolean safe, TeleportScanner scanner) {
        return this.teleportPlayer(player, location, player.getRotation(), centreBlock, scanner, this.getAppropriateFilter(player, safe), new TeleportHelperFilter[0]);
    }

    @Override
    public TeleportResult teleportPlayerSmart(Player player, Location<World> location, Vector3d rotation, boolean centreBlock, boolean safe, TeleportScanner scanner) {
        return this.teleportPlayer(player, location, rotation, centreBlock, scanner, this.getAppropriateFilter(player, safe), new TeleportHelperFilter[0]);
    }

    @Override
    public TeleportResult teleportPlayer(Player player, Location<World> location, boolean centreBlock, TeleportScanner scanner, TeleportHelperFilter filter, TeleportHelperFilter ... filters) {
        return this.teleportPlayer(player, location, player.getRotation(), centreBlock, scanner, filter, filters);
    }

    @Override
    public TeleportResult teleportPlayer(Player player, Location<World> location, Vector3d rotation, boolean centreBlock, TeleportScanner scanner, TeleportHelperFilter filter, TeleportHelperFilter ... filters) {
        Optional<Transform<World>> optionalWorldTransform = this.getSafeTransform(location, rotation, scanner, filter, filters);
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        if (optionalWorldTransform.isPresent()) {
            Transform targetLocation = optionalWorldTransform.get();
            AboutToTeleportEvent event = new AboutToTeleportEvent(cause, targetLocation, player);
            if (Sponge.getEventManager().post((Event)event)) {
                event.getCancelMessage().ifPresent(x -> {
                    Object o = cause.root();
                    if (o instanceof MessageReceiver) {
                        ((MessageReceiver)o).sendMessage(x);
                    }
                });
                return TeleportResult.FAIL_CANCELLED;
            }
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContexts.BYPASS_JAILING_RESTRICTION, (Object)true);
                Optional oe = player.getVehicle();
                if (oe.isPresent()) {
                    player.setVehicle(null);
                }
                if (centreBlock) {
                    targetLocation = new Transform(targetLocation.getExtent(), targetLocation.getLocation().getBlockPosition().toDouble().add(0.5, 0.5, 0.5), targetLocation.getRotation());
                }
                if (player.setTransform(targetLocation)) {
                    player.setSpectatorTarget(null);
                    TeleportResult teleportResult = TeleportResult.SUCCESS;
                    return teleportResult;
                }
                oe.ifPresent(arg_0 -> ((Player)player).setVehicle(arg_0));
            }
        }
        return TeleportResult.FAIL_NO_LOCATION;
    }

    @Override
    public Optional<Location<World>> getSafeLocation(Location<World> location, TeleportScanner scanner, TeleportHelperFilter filter, TeleportHelperFilter ... filters) {
        return scanner.scanFrom((World)location.getExtent(), location.getBlockPosition(), this.config.getHeight(), this.config.getWidth(), 2, filter, filters);
    }

    @Override
    public Optional<Transform<World>> getSafeTransform(Location<World> location, Vector3d rotation, TeleportScanner scanner, TeleportHelperFilter filter, TeleportHelperFilter ... filters) {
        return this.getSafeLocation(location, scanner, filter, filters).map(x -> new Transform(location.getExtent(), location.getPosition(), rotation));
    }

    @Override
    public TeleportHelperFilter getAppropriateFilter(Player src, boolean safeTeleport) {
        if (safeTeleport && !src.get(Keys.GAME_MODE).filter(x -> x == GameModes.SPECTATOR).isPresent()) {
            if (src.get(Keys.IS_FLYING).orElse(false).booleanValue()) {
                return TeleportHelperFilters.FLYING;
            }
            return TeleportHelperFilters.DEFAULT;
        }
        return NucleusTeleportHelperFilters.NO_CHECK.get();
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.config = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).getSafeTeleportConfig();
    }

    @Override
    public INucleusTeleportService.BorderDisableSession temporarilyDisableBorder(boolean reset, World world) {
        if (reset) {
            WorldBorder border = world.getWorldBorder();
            return new WorldBorderReset(border);
        }
        return DUMMY;
    }

    static class WorldBorderReset
    implements INucleusTeleportService.BorderDisableSession {
        private final double x;
        private final double z;
        private final double diameter;
        private final WorldBorder border;

        WorldBorderReset(WorldBorder border) {
            this.border = border;
            this.x = border.getCenter().getX();
            this.z = border.getCenter().getZ();
            this.diameter = border.getDiameter();
        }

        @Override
        public void close() {
            this.border.setCenter(this.x, this.z);
            this.border.setDiameter(this.diameter);
        }
    }
}

