/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.awt.Color;
import java.util.Random;
import lumien.randomthings.block.BlockContainerBase;
import lumien.randomthings.client.particles.EntityColoredSmokeFX;
import lumien.randomthings.item.block.ItemBlockLuminous;
import lumien.randomthings.lib.ILuminousBlock;
import lumien.randomthings.tileentity.TileEntitySlimeCube;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlimeCube
extends BlockContainerBase
implements ILuminousBlock {
    public static PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);

    protected BlockSlimeCube() {
        super("slimeCube", Material.field_151571_B, ItemBlockLuminous.class);
        this.func_149672_a(SoundType.field_185859_l);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntitySlimeCube) {
            TileEntitySlimeCube sc = (TileEntitySlimeCube)te;
            Color color = sc.isRedstonePowered() ? Color.RED.darker() : Color.GREEN.darker();
            for (int i = 0; i < 10; ++i) {
                int posZ;
                int posY;
                int posX = pos.func_177958_n() + rand.nextInt(11) - 5;
                BlockPos target = new BlockPos(posX, posY = pos.func_177956_o() + rand.nextInt(11) - 5, posZ = pos.func_177952_p() + rand.nextInt(11) - 5);
                IBlockState state = worldIn.func_180495_p(target);
                if (!state.func_185917_h() || !worldIn.func_175623_d(target.func_177984_a())) continue;
                EntityColoredSmokeFX fx = new EntityColoredSmokeFX(worldIn, posX, (double)posY + 0.9, posZ, 0.0, 0.1, 0.0);
                fx.func_187114_a(rand.nextInt(40) + 20);
                fx.func_70538_b(0.003921569f * (float)color.getRed(), 0.003921569f * (float)color.getGreen(), 0.003921569f * (float)color.getBlue());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
            }
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySlimeCube();
    }

    @Override
    public boolean shouldGlow(IBlockState state, int tintIndex) {
        return tintIndex == 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntitySlimeCube) {
            return state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(((TileEntitySlimeCube)te).isRedstonePowered()));
        }
        return super.func_176221_a(state, worldIn, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

