/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.economy.account;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.Contextual;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.service.economy.transaction.TransferResult;
import org.spongepowered.api.text.Text;

public interface Account
extends Contextual {
    public Text getDisplayName();

    public BigDecimal getDefaultBalance(Currency var1);

    public boolean hasBalance(Currency var1, Set<Context> var2);

    default public boolean hasBalance(Currency currency) {
        return this.hasBalance(currency, this.getActiveContexts());
    }

    public BigDecimal getBalance(Currency var1, Set<Context> var2);

    default public BigDecimal getBalance(Currency currency) {
        return this.getBalance(currency, this.getActiveContexts());
    }

    public Map<Currency, BigDecimal> getBalances(Set<Context> var1);

    default public Map<Currency, BigDecimal> getBalances() {
        return this.getBalances(this.getActiveContexts());
    }

    public TransactionResult setBalance(Currency var1, BigDecimal var2, Cause var3, Set<Context> var4);

    default public TransactionResult setBalance(Currency currency, BigDecimal amount, Cause cause) {
        return this.setBalance(currency, amount, cause, this.getActiveContexts());
    }

    public Map<Currency, TransactionResult> resetBalances(Cause var1, Set<Context> var2);

    default public Map<Currency, TransactionResult> resetBalances(Cause cause) {
        return this.resetBalances(cause, this.getActiveContexts());
    }

    public TransactionResult resetBalance(Currency var1, Cause var2, Set<Context> var3);

    default public TransactionResult resetBalance(Currency currency, Cause cause) {
        return this.resetBalance(currency, cause, this.getActiveContexts());
    }

    public TransactionResult deposit(Currency var1, BigDecimal var2, Cause var3, Set<Context> var4);

    default public TransactionResult deposit(Currency currency, BigDecimal amount, Cause cause) {
        return this.deposit(currency, amount, cause, this.getActiveContexts());
    }

    public TransactionResult withdraw(Currency var1, BigDecimal var2, Cause var3, Set<Context> var4);

    default public TransactionResult withdraw(Currency currency, BigDecimal amount, Cause cause) {
        return this.withdraw(currency, amount, cause, this.getActiveContexts());
    }

    public TransferResult transfer(Account var1, Currency var2, BigDecimal var3, Cause var4, Set<Context> var5);

    default public TransferResult transfer(Account to, Currency currency, BigDecimal amount, Cause cause) {
        return this.transfer(to, currency, amount, cause, this.getActiveContexts());
    }
}

