/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject;

import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.binder.AnnotatedBindingBuilder;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameRegistry;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.data.property.PropertyRegistry;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.service.ServiceManager;
import org.spongepowered.api.service.SimpleServiceManager;
import org.spongepowered.api.util.metric.MetricsConfigManager;
import org.spongepowered.api.world.TeleportHelper;
import org.spongepowered.common.SpongeBootstrap;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.asset.SpongeAssetManager;
import org.spongepowered.common.command.SpongeCommandDisambiguator;
import org.spongepowered.common.command.SpongeCommandManager;
import org.spongepowered.common.config.SpongeConfigManager;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.data.property.SpongePropertyRegistry;
import org.spongepowered.common.event.SpongeCauseStackManager;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.scheduler.SpongeScheduler;
import org.spongepowered.common.util.metric.SpongeMetricsConfigManager;
import org.spongepowered.common.world.teleport.SpongeTeleportHelper;

public class SpongeImplementationModule
extends PrivateModule {
    @Override
    @OverridingMethodsMustInvokeSuper
    protected void configure() {
        this.bindAndExpose(Game.class).to(SpongeGame.class);
        this.bindAndExpose(MinecraftVersion.class).toInstance(SpongeImpl.MINECRAFT_VERSION);
        this.bindAndExpose(ServiceManager.class).to(SimpleServiceManager.class);
        this.bindAndExpose(AssetManager.class).to(SpongeAssetManager.class);
        this.bindAndExpose(GameRegistry.class).to(SpongeGameRegistry.class);
        this.bindAndExpose(TeleportHelper.class).to(SpongeTeleportHelper.class);
        this.bindAndExpose(Scheduler.class).to(SpongeScheduler.class);
        this.bindAndExpose(CommandManager.class).to(SpongeCommandManager.class);
        this.bindAndExpose(DataManager.class).to(SpongeDataManager.class);
        this.bindAndExpose(ConfigManager.class).to(SpongeConfigManager.class);
        this.bindAndExpose(PropertyRegistry.class).to(SpongePropertyRegistry.class);
        this.bindAndExpose(CauseStackManager.class).to(SpongeCauseStackManager.class);
        this.bindAndExpose(MetricsConfigManager.class).to(SpongeMetricsConfigManager.class);
        this.expose(Platform.class);
        this.expose(PluginManager.class);
        this.expose(EventManager.class);
        this.expose(ChannelRegistrar.class);
        this.bind(org.apache.logging.log4j.Logger.class).toInstance(SpongeImpl.getLogger());
        this.bind(Logger.class).toInstance(LoggerFactory.getLogger(SpongeImpl.getLogger().getName()));
        this.requestStaticInjection(SpongeImpl.class);
        this.requestStaticInjection(Sponge.class);
        this.requestStaticInjection(SpongeBootstrap.class);
    }

    protected <T> AnnotatedBindingBuilder<T> bindAndExpose(Class<T> type) {
        this.expose(type);
        return this.bind(type);
    }

    @Provides
    @Singleton
    SpongeCommandManager commandManager(org.apache.logging.log4j.Logger logger, Game game) {
        return new SpongeCommandManager(logger, new SpongeCommandDisambiguator(game));
    }
}

