/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDoublePlantData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePortionData;
import org.spongepowered.api.data.type.DoublePlantType;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.type.PortionTypes;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDoublePlantData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePortionData;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={BlockDoublePlant.class})
public abstract class BlockDoublePlantMixin
extends BlockMixin {
    public ImmutableList<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.impl$getDoublePlantTypeFor(blockState), (Object)this.impl$getPortionData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableDoublePlantData.class.isAssignableFrom(immutable) || ImmutablePortionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableDoublePlantData) {
            BlockDoublePlant.EnumPlantType doublePlantType = (BlockDoublePlant.EnumPlantType)((ImmutableDoublePlantData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)doublePlantType));
        }
        if (manipulator instanceof ImmutablePortionData) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)this.impl$convertPortionType((PortionType)((ImmutablePortionData)manipulator).type().get())));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.DOUBLE_PLANT_TYPE)) {
            BlockDoublePlant.EnumPlantType doublePlantType = (BlockDoublePlant.EnumPlantType)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)doublePlantType));
        }
        if (key.equals(Keys.PORTION_TYPE)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockDoublePlant.field_176492_b, (Comparable)this.impl$convertPortionType((PortionType)value)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private BlockDoublePlant.EnumBlockHalf impl$convertPortionType(PortionType portionType) {
        return portionType == PortionTypes.BOTTOM ? BlockDoublePlant.EnumBlockHalf.LOWER : BlockDoublePlant.EnumBlockHalf.UPPER;
    }

    private ImmutableDoublePlantData impl$getDoublePlantTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDoublePlantData.class, (DoublePlantType)((Object)blockState.func_177229_b((IProperty)BlockDoublePlant.field_176493_a)));
    }

    private ImmutablePortionData impl$getPortionData(IBlockState blockState) {
        BlockDoublePlant.EnumBlockHalf half = (BlockDoublePlant.EnumBlockHalf)blockState.func_177229_b((IProperty)BlockDoublePlant.field_176492_b);
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePortionData.class, half == BlockDoublePlant.EnumBlockHalf.LOWER ? PortionTypes.BOTTOM : PortionTypes.TOP);
    }
}

