/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.BlockPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeConnectedDirectionData;
import org.spongepowered.common.mixin.core.block.BlockMixin;
import org.spongepowered.common.util.Constants;

@Mixin(value={BlockPane.class})
public abstract class BlockPaneMixin
extends BlockMixin {
    @Override
    public List<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.impl$getConnectedDirectionData(blockState));
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableConnectedDirectionData.class.isAssignableFrom(immutable);
    }

    private IBlockState impl$applyConnectedDirections(IBlockState blockState, Set<Direction> directions) {
        HashMap<PropertyBool, Boolean> facingStates = new HashMap<PropertyBool, Boolean>();
        for (PropertyBool property : Constants.DirectionFunctions.Pane.ALL_DIRECTION_PROPERTIES) {
            facingStates.put(property, false);
        }
        for (Direction connectedDirection : directions) {
            Optional<PropertyBool> facingPropertyBox = Constants.DirectionFunctions.Pane.getPropertyFromDirection(connectedDirection);
            facingPropertyBox.ifPresent(facingProperty -> facingStates.put((PropertyBool)facingProperty, true));
        }
        IBlockState resultBlockState = blockState;
        for (PropertyBool property : facingStates.keySet()) {
            resultBlockState = resultBlockState.func_177226_a((IProperty)property, (Comparable)facingStates.get(property));
        }
        return resultBlockState;
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableConnectedDirectionData) {
            ImmutableConnectedDirectionData connectedDirectionData = (ImmutableConnectedDirectionData)manipulator;
            return Optional.of((BlockState)this.impl$applyConnectedDirections(blockState, (Set)connectedDirectionData.connectedDirections().get()));
        }
        return super.bridge$getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.CONNECTED_DIRECTIONS)) {
            return Optional.of((BlockState)this.impl$applyConnectedDirections(blockState, (Set)value));
        }
        if (key.equals(Keys.CONNECTED_EAST)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPane.field_176242_M, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.CONNECTED_NORTH)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPane.field_176241_b, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.CONNECTED_SOUTH)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPane.field_176243_N, (Comparable)((Boolean)value)));
        }
        if (key.equals(Keys.CONNECTED_WEST)) {
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPane.field_176244_O, (Comparable)((Boolean)value)));
        }
        return super.bridge$getStateWithValue(blockState, key, value);
    }

    private ImmutableConnectedDirectionData impl$getConnectedDirectionData(IBlockState blockState) {
        EnumSet<Direction> directions = EnumSet.noneOf(Direction.class);
        Boolean north = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176241_b);
        Boolean east = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176242_M);
        Boolean west = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176244_O);
        Boolean south = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176243_N);
        if (north.booleanValue()) {
            directions.add(Direction.NORTH);
        }
        if (south.booleanValue()) {
            directions.add(Direction.SOUTH);
        }
        if (west.booleanValue()) {
            directions.add(Direction.WEST);
        }
        if (east.booleanValue()) {
            directions.add(Direction.EAST);
        }
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeConnectedDirectionData.class, directions);
    }
}

