/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import java.util.Random;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.block.GrowablePhaseContext;
import org.spongepowered.common.mixin.core.item.ItemMixin;

@Mixin(value={ItemDye.class})
public abstract class ItemDyeMixin
extends ItemMixin {
    @Redirect(method={"applyBonemeal"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/IGrowable;grow(Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;)V"), require=0, expect=0)
    private static void onGrowableVanilla(IGrowable iGrowable, World worldIn, Random rand, BlockPos pos, IBlockState blockState, ItemStack stack, World sameWorld, BlockPos target) {
        if (((WorldBridge)worldIn).bridge$isFake() || !ShouldFire.CHANGE_BLOCK_EVENT_GROW) {
            iGrowable.func_176474_b(worldIn, rand, pos, blockState);
            return;
        }
        PhaseContext<?> current = PhaseTracker.getInstance().getCurrentContext();
        IPhaseState state = current.state;
        boolean doesBulk = state.doesBulkBlockCapture(current);
        boolean doesEvent = state.doesBlockEventTracking(current);
        if (doesBulk || doesEvent) {
            try (GrowablePhaseContext context = BlockPhase.State.GROWING.createPhaseContext().provideItem(stack).world(worldIn).block(blockState).pos(pos);){
                context.buildAndSwitch();
                iGrowable.func_176474_b(worldIn, rand, pos, blockState);
            }
        }
    }
}

