/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.block;

import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.util.rotation.Rotations;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;
import org.spongepowered.common.rotation.SpongeRotation;

@RegisterCatalog(value=Rotations.class)
public final class RotationRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<Rotation>
implements CatalogRegistryModule<Rotation> {
    public static RotationRegistryModule getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void registerDefaults() {
        this.register(new SpongeRotation(0, "minecraft:top", "Top"));
        this.register(new SpongeRotation(45, "minecraft:top_right", "Top Right"));
        this.register(new SpongeRotation(90, "minecraft:right", "Right"));
        this.register(new SpongeRotation(135, "minecraft:bottom_right", "Bottom Right"));
        this.register(new SpongeRotation(180, "minecraft:bottom", "Bottom"));
        this.register(new SpongeRotation(225, "minecraft:bottom_left", "Bottom Left"));
        this.register(new SpongeRotation(270, "minecraft:left", "Left"));
        this.register(new SpongeRotation(315, "minecraft:top_left", "Top Left"));
    }

    RotationRegistryModule() {
        super("minecraft");
    }

    public Optional<Rotation> getRotationFromDegree(int degrees) {
        for (Map.Entry entry : this.catalogTypeMap.entrySet()) {
            if (((Rotation)entry.getValue()).getAngle() != degrees) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private static final class Holder {
        static final RotationRegistryModule INSTANCE = new RotationRegistryModule();

        private Holder() {
        }
    }
}

