/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiEmbeddedGaugeTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBoilerTab;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiThermoelectricBoiler
extends GuiEmbeddedGaugeTile<TileEntityBoilerCasing> {
    public GuiThermoelectricBoiler(InventoryPlayer inventory, TileEntityBoilerCasing tile) {
        super(tile, new ContainerFilter(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiBoilerTab(this, (TileEntityBoilerCasing)this.tileEntity, GuiBoilerTab.BoilerTab.STAT, 6, resource));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.boilRate") + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).lastBoilRate + " mB/t";
            }

            @Override
            public double getLevel() {
                return (double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).lastBoilRate / (double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).lastMaxBoil;
            }
        }, resource, 24, 13));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.maxBoil") + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).lastMaxBoil + " mB/t";
            }

            @Override
            public double getLevel() {
                double cap = (double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).superheatingElements * MekanismConfig.current().general.superheatingHeatTransfer.val() / SynchronizedBoilerData.getHeatEnthalpy();
                return (double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).lastMaxBoil / cap;
            }
        }, resource, 144, 13));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).lastEnvironmentLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(((TileEntityBoilerCasing)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityBoilerCasing)this.tileEntity).func_70005_c_()) / 2, 5, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).temperature, UnitDisplayUtils.TemperatureUnit.AMBIENT), 43, 30, 52480, 90);
        this.renderScaledText(LangUtils.localize("gui.boilRate") + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).lastBoilRate + " mB/t", 43, 39, 52480, 90);
        this.renderScaledText(LangUtils.localize("gui.maxBoil") + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).lastMaxBoil + " mB/t", 43, 48, 52480, 90);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).waterStored != null ? LangUtils.localizeFluidStack(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).waterStored) + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).waterStored.amount + "mB" : LangUtils.localize("gui.empty"), xAxis, yAxis);
        }
        if (xAxis >= 153 && xAxis <= 169 && yAxis >= 14 && yAxis <= 72) {
            this.func_146279_a(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored != null ? LangUtils.localizeFluidStack(((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored) + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored.amount + "mB" : LangUtils.localize("gui.empty"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((TileEntityBoilerCasing)this.tileEntity).getScaledWaterLevel(58) > 0) {
            this.displayGauge(7, 14, ((TileEntityBoilerCasing)this.tileEntity).getScaledWaterLevel(58), ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).waterStored);
        }
        if (((TileEntityBoilerCasing)this.tileEntity).getScaledSteamLevel(58) > 0) {
            this.displayGauge(153, 14, ((TileEntityBoilerCasing)this.tileEntity).getScaledSteamLevel(58), ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiThermoelectricBoiler.png");
    }

    @Override
    protected ResourceLocation getGaugeResource() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiIndustrialTurbine.png");
    }
}

