/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.util.ItemRegistryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiOredictionificatorFilter
extends GuiMekanismTile<TileEntityOredictionificator> {
    private TileEntityOredictionificator.OredictionificatorFilter origFilter;
    private TileEntityOredictionificator.OredictionificatorFilter filter = new TileEntityOredictionificator.OredictionificatorFilter();
    private GuiTextField filterText;
    private boolean isNew;
    private ItemStack renderStack = ItemStack.field_190927_a;

    public GuiOredictionificatorFilter(EntityPlayer player, TileEntityOredictionificator tile, int index) {
        super(tile, new ContainerFilter(player.field_71071_by, tile));
        this.origFilter = ((TileEntityOredictionificator)this.tileEntity).filters.get(index);
        this.filter = ((TileEntityOredictionificator)this.tileEntity).filters.get(index).clone();
        this.updateRenderStack();
    }

    public GuiOredictionificatorFilter(EntityPlayer player, TileEntityOredictionificator tile) {
        super(tile, new ContainerFilter(player.field_71071_by, tile));
        this.isNew = true;
    }

    public void setFilter() {
        String newFilter = this.filterText.func_146179_b();
        boolean has = false;
        for (String s : TileEntityOredictionificator.possibleFilters) {
            if (!newFilter.startsWith(s)) continue;
            has = true;
            break;
        }
        if (has) {
            this.filter.filter = newFilter;
            this.filter.index = 0;
            this.filterText.func_146180_a("");
            this.updateRenderStack();
        }
        this.updateButtons();
    }

    public void updateButtons() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = this.filter.filter != null && !this.filter.filter.isEmpty();
        ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = !this.isNew;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, guiWidth + 31, guiHeight + 62, 54, 20, LangUtils.localize("gui.save")));
        this.field_146292_n.add(new GuiButton(1, guiWidth + 89, guiHeight + 62, 54, 20, LangUtils.localize("gui.delete")));
        if (this.isNew) {
            ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = false;
        }
        this.filterText = new GuiTextField(2, this.field_146289_q, guiWidth + 33, guiHeight + 48, 96, 12);
        this.filterText.func_146203_f(24);
        this.filterText.func_146195_b(true);
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String text = (this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.filter");
        this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.index") + ": " + this.filter.index, 79, 23, 0x404040);
        if (this.filter.filter != null) {
            this.renderScaledText(this.filter.filter, 32, 38, 0x404040, 111);
        }
        if (!this.renderStack.func_190926_b()) {
            try {
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                this.field_146296_j.func_180450_b(this.renderStack, 45, 19);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 31 && xAxis <= 43 && yAxis >= 21 && yAxis <= 33) {
            this.func_146279_a(LangUtils.localize("gui.lastItem"), xAxis, yAxis);
        }
        if (xAxis >= 63 && xAxis <= 75 && yAxis >= 21 && yAxis <= 33) {
            this.func_146279_a(LangUtils.localize("gui.nextItem"), xAxis, yAxis);
        }
        if (xAxis >= 33 && xAxis <= 129 && yAxis >= 48 && yAxis <= 60) {
            this.func_146279_a(LangUtils.localize("gui.oreDictCompat"), xAxis, yAxis);
        }
        if (xAxis >= 45 && xAxis <= 61 && yAxis >= 19 && yAxis <= 35 && !this.renderStack.func_190926_b()) {
            String name = ItemRegistryUtils.getMod(this.renderStack);
            String extra = name.equals("null") ? "" : " (" + name + ")";
            this.func_146279_a(this.renderStack.func_82833_r() + extra, xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 212, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 212, 11, 11, 11);
        }
        if (xAxis >= 31 && xAxis <= 43 && yAxis >= 21 && yAxis <= 33) {
            this.func_73729_b(guiWidth + 31, guiHeight + 21, 200, 0, 12, 12);
        } else {
            this.func_73729_b(guiWidth + 31, guiHeight + 21, 200, 12, 12, 12);
        }
        if (xAxis >= 63 && xAxis <= 75 && yAxis >= 21 && yAxis <= 33) {
            this.func_73729_b(guiWidth + 63, guiHeight + 21, 188, 0, 12, 12);
        } else {
            this.func_73729_b(guiWidth + 63, guiHeight + 21, 188, 12, 12, 12);
        }
        if (xAxis >= 130 && xAxis <= 142 && yAxis >= 48 && yAxis <= 60) {
            this.func_73729_b(guiWidth + 130, guiHeight + 48, 176, 0, 12, 12);
        } else {
            this.func_73729_b(guiWidth + 130, guiHeight + 48, 176, 12, 12, 12);
        }
        this.filterText.func_146194_f();
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.filterText.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (this.filterText.func_146206_l() && i == 28) {
            this.setFilter();
            return;
        }
        if (Character.isLetter(c) || Character.isDigit(c) || GuiOredictionificatorFilter.isTextboxKey(c, i)) {
            this.filterText.func_146201_a(c, i);
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            if (!this.filterText.func_146179_b().isEmpty()) {
                this.setFilter();
            }
            if (this.filter.filter != null && !this.filter.filter.isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(this.tileEntity), 0, 52));
            }
        } else if (guibutton.field_146127_k == 1) {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), true, this.origFilter, null));
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(this.tileEntity), 0, 52));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.filterText.func_146178_a();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.filterText.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            NonNullList ores;
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(this.tileEntity), 0, 52));
            }
            if (xAxis >= 130 && xAxis <= 142 && yAxis >= 48 && yAxis <= 60) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                this.setFilter();
            }
            if (xAxis >= 31 && xAxis <= 43 && yAxis >= 21 && yAxis <= 33) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                if (this.filter.filter != null) {
                    ores = OreDictionary.getOres((String)this.filter.filter, (boolean)false);
                    this.filter.index = this.filter.index > 0 ? --this.filter.index : ores.size() - 1;
                    this.updateRenderStack();
                }
            }
            if (xAxis >= 63 && xAxis <= 75 && yAxis >= 21 && yAxis <= 33) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                if (this.filter.filter != null) {
                    ores = OreDictionary.getOres((String)this.filter.filter, (boolean)false);
                    this.filter.index = this.filter.index < ores.size() - 1 ? ++this.filter.index : 0;
                    this.updateRenderStack();
                }
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiOredictionificatorFilter.png");
    }

    public void updateRenderStack() {
        if (this.filter.filter == null || this.filter.filter.isEmpty()) {
            this.renderStack = ItemStack.field_190927_a;
            return;
        }
        NonNullList stacks = OreDictionary.getOres((String)this.filter.filter, (boolean)false);
        if (stacks.isEmpty()) {
            this.renderStack = ItemStack.field_190927_a;
            return;
        }
        this.renderStack = stacks.size() - 1 >= this.filter.index ? ((ItemStack)stacks.get(this.filter.index)).func_77946_l() : ItemStack.field_190927_a;
    }
}

