/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.util;

import com.erigitic.main.TotalEconomy;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class MessageManager {
    private TotalEconomy totalEconomy;
    private Logger logger;
    private ConfigurationNode messagesConfig;
    private Locale locale;

    public MessageManager(TotalEconomy totalEconomy, Logger logger, Locale locale) {
        this.totalEconomy = totalEconomy;
        this.logger = logger;
        this.locale = locale;
        this.setupConfig(locale);
    }

    private void setupConfig(Locale locale) {
        File messagesFile = new File(this.totalEconomy.getConfigDir(), "messages_" + locale.getLanguage() + ".conf");
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(messagesFile)).build();
        try {
            if (!messagesFile.exists()) {
                Asset defaultMessagesAsset = (Asset)this.totalEconomy.getPluginContainer().getAsset("messages_en.conf").get();
                Optional optMessagesAsset = this.totalEconomy.getPluginContainer().getAsset("messages_" + locale.getLanguage() + ".conf");
                optMessagesAsset.orElse(defaultMessagesAsset).copyToFile(messagesFile.toPath());
            }
            this.messagesConfig = loader.load();
        }
        catch (IOException e) {
            this.logger.warn("[TE] Error loading/creating the messages configuration file!");
        }
    }

    public Text getMessage(String messageKey) {
        String message = this.messagesConfig.getNode(new Object[]{messageKey}).getString("Message not found (" + this.locale + "): " + messageKey);
        return TextSerializers.FORMATTING_CODE.deserialize(message);
    }

    public Text getMessage(String messageKey, Map<String, String> values) {
        StrSubstitutor sub = new StrSubstitutor(values, "{", "}");
        String message = sub.replace(this.messagesConfig.getNode(new Object[]{messageKey}).getString("Message not found (" + this.locale + "): " + messageKey));
        return TextSerializers.FORMATTING_CODE.deserialize(message);
    }
}

