/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.Arrays;
import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.integration.crafttweaker.AddProcessorRecipe;
import nc.integration.crafttweaker.CTHelper;
import nc.integration.crafttweaker.RemoveAllProcessorRecipes;
import nc.integration.crafttweaker.RemoveProcessorRecipe;
import nc.radiation.RadSources;
import nc.radiation.RadiationHelper;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;

public class NCCraftTweaker {

    @ZenRegister
    @ZenExpansion(value="crafttweaker.entity.IEntityLivingBase")
    public static class EntityExpansion {
        @ZenMethod
        public static void addRadiation(IEntityLivingBase entity, double amount, @Optional boolean useImmunity) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setTotalRads(rads.getTotalRads() + amount, useImmunity);
            }
        }

        @ZenMethod
        public static void setRadiation(IEntityLivingBase entity, double amount, @Optional boolean useImmunity) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setTotalRads(amount, useImmunity);
            }
        }

        @ZenMethod
        public static double getRadiation(IEntityLivingBase entity) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            return rads == null ? 0.0 : rads.getTotalRads();
        }

        @ZenMethod
        public static void addRadawayBuffer(IEntityLivingBase entity, double amount, @Optional boolean slow) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setRadawayBuffer(slow, rads.getRadawayBuffer(slow) + amount);
                if (!slow) {
                    rads.setRecentRadawayAddition(Math.abs(amount));
                }
            }
        }

        @ZenMethod
        public static void setRadawayBuffer(IEntityLivingBase entity, double amount, @Optional boolean slow) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setRadawayBuffer(slow, amount);
                if (!slow) {
                    rads.setRecentRadawayAddition(Math.abs(amount));
                }
            }
        }

        @ZenMethod
        public static double getRadawayBuffer(IEntityLivingBase entity, @Optional boolean slow) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            return rads == null ? 0.0 : rads.getRadawayBuffer(slow);
        }

        @ZenMethod
        public static void addPoisonBuffer(IEntityLivingBase entity, double amount) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setPoisonBuffer(rads.getPoisonBuffer() + amount);
                rads.setRecentPoisonAddition(Math.abs(amount));
            }
        }

        @ZenMethod
        public static void setPoisonBuffer(IEntityLivingBase entity, double amount) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setPoisonBuffer(amount);
                rads.setRecentPoisonAddition(Math.abs(amount));
            }
        }

        @ZenMethod
        public static double getPoisonBuffer(IEntityLivingBase entity) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            return rads == null ? 0.0 : rads.getPoisonBuffer();
        }

        @ZenMethod
        public static void addRadiationResistance(IEntityLivingBase entity, double amount) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setInternalRadiationResistance(rads.getInternalRadiationResistance() + amount);
                rads.setRecentRadXAddition(Math.abs(amount));
            }
        }

        @ZenMethod
        public static void setRadiationResistance(IEntityLivingBase entity, double amount) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            if (rads != null) {
                rads.setInternalRadiationResistance(amount);
                rads.setRecentRadXAddition(Math.abs(amount));
            }
        }

        @ZenMethod
        public static double getRadiationResistance(IEntityLivingBase entity) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            return rads == null ? 0.0 : rads.getInternalRadiationResistance();
        }

        @ZenMethod
        public static double getRawRadiationLevel(IEntityLivingBase entity) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            return rads == null ? 0.0 : rads.getRawRadiationLevel();
        }

        @ZenMethod
        public static double getRadiationLevel(IEntityLivingBase entity) {
            IEntityRads rads = EntityExpansion.entityRads(entity);
            return rads == null ? 0.0 : rads.getRadiationLevel();
        }

        private static IEntityRads entityRads(IEntityLivingBase entity) {
            return RadiationHelper.getEntityRadiation(CraftTweakerMC.getEntityLivingBase((IEntityLivingBase)entity));
        }
    }

    @ZenClass(value="mods.nuclearcraft.radiation")
    @ZenRegister
    public static class RadiationHandler {
        @ZenMethod
        public static double getRadiationLevel(IIngredient ingredient) {
            if (ingredient == null) {
                return 0.0;
            }
            if (ingredient instanceof IItemStack) {
                ItemStack stack = CTHelper.getItemStack((IItemStack)ingredient);
                if (stack.func_190926_b()) {
                    return 0.0;
                }
                return RadSources.STACK_MAP.get(RecipeItemHelper.func_194113_b((ItemStack)stack)) * (double)stack.func_190916_E();
            }
            if (ingredient instanceof IOreDictEntry) {
                String oreName = ((IOreDictEntry)ingredient).getName();
                int amount = ((IOreDictEntry)ingredient).getAmount();
                return RadSources.ORE_MAP.getDouble((Object)oreName) * (double)amount;
            }
            if (ingredient instanceof IngredientStack) {
                IItemIngredient ing = CTHelper.buildOreIngredientArray((IngredientStack)ingredient, true);
                if (ing instanceof OreIngredient) {
                    String oreName = ((OreIngredient)ing).oreName;
                    int amount = ((OreIngredient)ing).stackSize;
                    return RadSources.ORE_MAP.getDouble((Object)oreName) * (double)amount;
                }
                ItemStack stack = (ItemStack)ing.getStack();
                if (stack == null || stack.func_190926_b()) {
                    return 0.0;
                }
                return RadSources.STACK_MAP.get(RecipeItemHelper.func_194113_b((ItemStack)stack)) * (double)stack.func_190916_E();
            }
            return 0.0;
        }

        @ZenMethod
        public static void addBlockMutation(IIngredient input, IIngredient output, double threshold) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.radiation_block_mutations, Lists.newArrayList((Object[])new Object[]{input, output, threshold})));
        }

        @ZenMethod
        public static void setRadiationImmunityGameStages(boolean defaultImmunity, String ... stageNames) {
            nc.radiation.RadiationHandler.default_rad_immunity = defaultImmunity;
            nc.radiation.RadiationHandler.rad_immunity_stages = stageNames;
            CraftTweakerAPI.logInfo((String)("Added radiation immunity game stages " + Arrays.asList(stageNames).toString() + ", with immunity " + (defaultImmunity ? "enabled" : "disabled") + " by default"));
        }
    }

    @ZenClass(value="mods.nuclearcraft.condenser")
    @ZenRegister
    public static class CondenserHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.condenser, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.condenser, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.condenser, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.condenser));
        }
    }

    @ZenClass(value="mods.nuclearcraft.turbine")
    @ZenRegister
    public static class TurbineHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.turbine, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.turbine, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.turbine, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.turbine));
        }
    }

    @ZenClass(value="mods.nuclearcraft.heat_exchanger")
    @ZenRegister
    public static class HeatExchangerHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.heat_exchanger, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.heat_exchanger, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.heat_exchanger, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.heat_exchanger));
        }
    }

    @ZenClass(value="mods.nuclearcraft.salt_fission")
    @ZenRegister
    public static class SaltFissionHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.salt_fission, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_fission, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_fission, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.salt_fission));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, double fuelTime, double power) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.salt_fission, Lists.newArrayList((Object[])new Object[]{input1, output1, fuelTime, power})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_fission, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_fission, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.fusion")
    @ZenRegister
    public static class FusionHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.fusion, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fusion, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fusion, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.fusion));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, double fuelTime, double power, double heatVar) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.fusion, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, output3, output4, fuelTime, power, heatVar})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fusion, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fusion, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.fission")
    @ZenRegister
    public static class FissionHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.fission, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fission, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fission, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.fission));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, double fuelTime, double power, double heat, String name) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.fission, Lists.newArrayList((Object[])new Object[]{input1, output1, fuelTime, power, heat, name})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fission, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fission, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.decay_generator")
    @ZenRegister
    public static class DecayGeneratorHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.decay_generator, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_generator, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_generator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.decay_generator));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, double lifetime, int power) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.decay_generator, Lists.newArrayList((Object[])new Object[]{input1, output1, lifetime, (double)power})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_generator, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_generator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.rock_crusher")
    @ZenRegister
    public static class RockCrusherHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.rock_crusher, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.rock_crusher, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.rock_crusher, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.rock_crusher));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.rock_crusher, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.rock_crusher, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, (double)processTime / (double)NCConfig.processor_time[18]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.rock_crusher, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.rock_crusher, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.centrifuge")
    @ZenRegister
    public static class CentrifugeHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.centrifuge, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.centrifuge, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.centrifuge, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.centrifuge));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.centrifuge, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, output4, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.centrifuge, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, output4, (double)processTime / (double)NCConfig.processor_time[17]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.centrifuge, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.centrifuge, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.extractor")
    @ZenRegister
    public static class ExtractorHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.extractor, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.extractor, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.extractor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.extractor));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.extractor, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.extractor, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, (double)processTime / (double)NCConfig.processor_time[16]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.extractor, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.extractor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.dissolver")
    @ZenRegister
    public static class DissolverHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.dissolver, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.dissolver, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.dissolver, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.dissolver));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.dissolver, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.dissolver, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, (double)processTime / (double)NCConfig.processor_time[15]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.dissolver, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.dissolver, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.crystallizer")
    @ZenRegister
    public static class CrystallizerHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.crystallizer, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.crystallizer, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.crystallizer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.crystallizer));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.crystallizer, Lists.newArrayList((Object[])new Object[]{input1, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.crystallizer, Lists.newArrayList((Object[])new Object[]{input1, output1, (double)processTime / (double)NCConfig.processor_time[14]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.crystallizer, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.crystallizer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.salt_mixer")
    @ZenRegister
    public static class SaltMixerHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.salt_mixer, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_mixer, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_mixer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.salt_mixer));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.salt_mixer, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.salt_mixer, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, (double)processTime / (double)NCConfig.processor_time[13]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_mixer, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.salt_mixer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.chemical_reactor")
    @ZenRegister
    public static class ChemicalReactorHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.chemical_reactor, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.chemical_reactor, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.chemical_reactor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.chemical_reactor));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.chemical_reactor, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.chemical_reactor, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, (double)processTime / (double)NCConfig.processor_time[12]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.chemical_reactor, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.chemical_reactor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.pressurizer")
    @ZenRegister
    public static class PressurizerHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.pressurizer, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.pressurizer, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.pressurizer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.pressurizer));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.pressurizer, Lists.newArrayList((Object[])new Object[]{input1, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.pressurizer, Lists.newArrayList((Object[])new Object[]{input1, output1, (double)processTime / (double)NCConfig.processor_time[11]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.pressurizer, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.pressurizer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.ingot_former")
    @ZenRegister
    public static class IngotFormerHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.ingot_former, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.ingot_former, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.ingot_former, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.ingot_former));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.ingot_former, Lists.newArrayList((Object[])new Object[]{input1, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.ingot_former, Lists.newArrayList((Object[])new Object[]{input1, output1, (double)processTime / (double)NCConfig.processor_time[10]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.ingot_former, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.ingot_former, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.irradiator")
    @ZenRegister
    public static class IrradiatorHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.irradiator, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.irradiator, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.irradiator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.irradiator));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.irradiator, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.irradiator, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, (double)processTime / (double)NCConfig.processor_time[9]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.irradiator, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.irradiator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.electrolyser")
    @ZenRegister
    public static class ElectrolyserHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.electrolyser, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.electrolyser, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.electrolyser, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.electrolyser));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.electrolyser, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, output4, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.electrolyser, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, output4, (double)processTime / (double)NCConfig.processor_time[8]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.electrolyser, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.electrolyser, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.supercooler")
    @ZenRegister
    public static class SupercoolerHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.supercooler, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.supercooler, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.supercooler, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.supercooler));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.supercooler, Lists.newArrayList((Object[])new Object[]{input1, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.supercooler, Lists.newArrayList((Object[])new Object[]{input1, output1, (double)processTime / (double)NCConfig.processor_time[7]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.supercooler, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.supercooler, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.melter")
    @ZenRegister
    public static class MelterHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.melter, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.melter, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.melter, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.melter));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.melter, Lists.newArrayList((Object[])new Object[]{input1, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.melter, Lists.newArrayList((Object[])new Object[]{input1, output1, (double)processTime / (double)NCConfig.processor_time[6]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.melter, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.melter, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.infuser")
    @ZenRegister
    public static class InfuserHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.infuser, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.infuser, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.infuser, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.infuser));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.infuser, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.infuser, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, (double)processTime / (double)NCConfig.processor_time[5]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.infuser, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.infuser, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.alloy_furnace")
    @ZenRegister
    public static class AlloyFurnaceHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.alloy_furnace, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.alloy_furnace, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.alloy_furnace, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.alloy_furnace));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.alloy_furnace, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.alloy_furnace, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, (double)processTime / (double)NCConfig.processor_time[4]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.alloy_furnace, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.alloy_furnace, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.fuel_reprocessor")
    @ZenRegister
    public static class FuelReprocessorHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.fuel_reprocessor, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fuel_reprocessor, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fuel_reprocessor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.fuel_reprocessor));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.fuel_reprocessor, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, output4, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.fuel_reprocessor, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, output3, output4, (double)processTime / (double)NCConfig.processor_time[3]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fuel_reprocessor, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.fuel_reprocessor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.decay_hastener")
    @ZenRegister
    public static class DecayHastenerHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.decay_hastener, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_hastener, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_hastener, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.decay_hastener));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.decay_hastener, Lists.newArrayList((Object[])new Object[]{input1, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.decay_hastener, Lists.newArrayList((Object[])new Object[]{input1, output1, (double)processTime / (double)NCConfig.processor_time[2]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_hastener, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.decay_hastener, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.isotope_separator")
    @ZenRegister
    public static class IsotopeSeparatorHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.isotope_separator, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.isotope_separator, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.isotope_separator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.isotope_separator));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.isotope_separator, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, IIngredient output2, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.isotope_separator, Lists.newArrayList((Object[])new Object[]{input1, output1, output2, (double)processTime / (double)NCConfig.processor_time[1]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.isotope_separator, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.isotope_separator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }
    }

    @ZenClass(value="mods.nuclearcraft.manufactory")
    @ZenRegister
    public static class ManufactoryHandler {
        @ZenMethod
        public static void addRecipe(Object[] objects) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.manufactory, Lists.newArrayList((Object[])objects)));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient[] inputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.manufactory, IngredientSorption.INPUT, Lists.newArrayList((Object[])inputs)));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient[] outputs) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.manufactory, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])outputs)));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new RemoveAllProcessorRecipes(NCRecipes.manufactory));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.manufactory, Lists.newArrayList((Object[])new Object[]{input1, output1, 1.0})));
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient output1, int processTime) {
            CraftTweakerAPI.apply((IAction)new AddProcessorRecipe(NCRecipes.manufactory, Lists.newArrayList((Object[])new Object[]{input1, output1, (double)processTime / (double)NCConfig.processor_time[0]})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.manufactory, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1) {
            CraftTweakerAPI.apply((IAction)new RemoveProcessorRecipe(NCRecipes.manufactory, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1})));
        }
    }
}

