/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pregenerator.ChunkPregenerator;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.PrepaireProgress;
import pregenerator.impl.processor.deleter.DeleteProcess;
import pregenerator.impl.processor.deleter.IDeletionTask;

public class DeleteChunkSubCommand
extends BasePregenCommand {
    public DeleteChunkSubCommand() {
        super(4);
        this.addDescription(0, "X Position: The X Chunk Position of the Deletion. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(1, "Z Position: The Z Chunk Position of the Deletion. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "(Optional) Dimension: The Dimension the Deletion should be happening in");
        this.addDescription(3, "(Optional) Delay: How long the Deleter should wait until it should start (in ticks)");
        this.addSuggestion("deleteChunk 100 200", "Deletes a Unloaded Chunk at X100 Z200 at the Dimension that the sender is at");
    }

    @Override
    public String getName() {
        return "deleteChunk";
    }

    @Override
    public String getDescription() {
        return "Deletes a Single Unloaded Chunk";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        if (args.length >= 2) {
            FilePos position = DeleteChunkSubCommand.getChunkPos(args[0], args[1], container.getPlayerPos());
            int dimension = DeleteChunkSubCommand.getDimension(container, DeleteChunkSubCommand.getArg(args, 2));
            int delay = DeleteChunkSubCommand.parseNumber(DeleteChunkSubCommand.getArg(args, 3), 0);
            if (!DeleteChunkSubCommand.isDimensionValid(dimension)) {
                container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                return;
            }
            container.onProcessStarted();
            container.getDeleter().startTask(new SingleDeletion(dimension, position, delay));
        } else {
            this.throwErrors(container, args.length);
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0 || commandIndex == 1) {
            return DeleteChunkSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 2) {
            return DeleteChunkSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        if (commandIndex == 3) {
            return DeleteChunkSubCommand.getBestMatch(args, CompleterHelper.GEN_DELAY);
        }
        return new ArrayList<String>();
    }

    private Map<FilePos, Set<FilePos>> createTask(FilePos pos) {
        LinkedHashMap<FilePos, Set<FilePos>> map = new LinkedHashMap<FilePos, Set<FilePos>>();
        LinkedHashSet<FilePos> file = new LinkedHashSet<FilePos>();
        file.add(pos);
        map.put(pos.toChunkFile(), file);
        return map;
    }

    public static class SingleDeletion
    extends IDeletionTask {
        int dim;
        FilePos position;

        public SingleDeletion(int dimension, FilePos pos, int delay) {
            this.dim = dimension;
            this.position = pos;
        }

        @Override
        public Future<DeleteProcess> createTask(final PrepaireProgress progress) {
            progress.setMax(1L);
            final boolean loaded = DimensionManager.getWorld((int)this.dim) != null;
            final WorldServer world = this.getWorld(this.dim);
            final File file = world.getChunkSaveLocation();
            if (!loaded) {
                DimensionManager.unloadWorld((int)this.dim);
            }
            return ChunkPregenerator.SERVICE.submit(new Callable<DeleteProcess>(){

                @Override
                public DeleteProcess call() throws Exception {
                    DeleteProcess process = new DeleteProcess(file, this.createTask(position));
                    progress.growValue(1);
                    if (loaded) {
                        process.setChunkHost(world);
                    }
                    return process;
                }
            });
        }

        private Map<Long, BitSet> createTask(FilePos pos) {
            LinkedHashMap<Long, BitSet> map = new LinkedHashMap<Long, BitSet>();
            BitSet set = new BitSet();
            set.set((pos.z & 0x1F) * 32 + (pos.x & 0x1F));
            map.put(pos.toChunkFile().asLong(), set);
            return map;
        }
    }
}

