/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.processor;

import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.util.math.ChunkPos;
import pregenerator.impl.misc.FilePos;
import pregenerator.impl.processor.PrepaireProgress;

public class ChunkCalculator {
    public static Map<Long, BitSet> createArea(int xStart, int zStart, int xEnd, int zEnd, PrepaireProgress progress) {
        LinkedHashMap<Long, BitSet> storage = new LinkedHashMap<Long, BitSet>();
        for (int x = xStart; x < xEnd; ++x) {
            for (int z = zStart; z < zEnd; ++z) {
                Long value = ChunkPos.func_77272_a((int)(x >> 5), (int)(z >> 5));
                BitSet set = (BitSet)storage.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    storage.put(value, set);
                }
                set.set((z & 0x1F) * 32 + (x & 0x1F));
                progress.growValue(1);
            }
        }
        return storage;
    }

    public static Map<Long, BitSet> createCircleArea(int xStart, int zStart, int xEnd, int zEnd, int centerX, int centerZ, int radius, PrepaireProgress progress) {
        LinkedHashMap<Long, BitSet> storage = new LinkedHashMap<Long, BitSet>();
        for (int x = xStart; x < xEnd; ++x) {
            for (int z = zStart; z < zEnd; ++z) {
                FilePos pos = new FilePos(x, z);
                if (pos.getSqDistance(centerX, centerZ) > (double)radius) continue;
                Long value = ChunkPos.func_77272_a((int)(x >> 5), (int)(z >> 5));
                BitSet set = (BitSet)storage.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    storage.put(value, set);
                }
                set.set((z & 0x1F) * 32 + (x & 0x1F));
                progress.growValue(1);
            }
        }
        return storage;
    }

    public static Map<Long, BitSet> createSquare(int xPos, int zPos, int radius, PrepaireProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                Long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
                progress.growValue(1);
            }
        }
        return result;
    }

    public static Map<Long, BitSet> createSquareExt(int xPos, int zPos, int minRadius, int maxRadius, PrepaireProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (x > -minRadius && x <= minRadius && z > -minRadius && z <= minRadius) continue;
                Long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
            }
        }
        return result;
    }

    public static Map<Long, BitSet> createCircle(int xPos, int zPos, int radius, PrepaireProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                progress.growValue(1);
                if (ChunkCalculator.isNotInReach(x, z, radius)) continue;
                Long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
            }
        }
        return result;
    }

    public static Map<Long, BitSet> createCircleExt(int xPos, int zPos, int minRadius, int maxRadius, PrepaireProgress progress) {
        LinkedHashMap<Long, BitSet> result = new LinkedHashMap<Long, BitSet>();
        for (int x = -maxRadius; x < maxRadius; ++x) {
            for (int z = -maxRadius; z < maxRadius; ++z) {
                progress.growValue(1);
                if (ChunkCalculator.isNotInRange(x, z, minRadius, maxRadius)) continue;
                Long value = ChunkPos.func_77272_a((int)(x + xPos >> 5), (int)(z + zPos >> 5));
                BitSet set = (BitSet)result.get(value);
                if (set == null) {
                    set = new BitSet(1024);
                    result.put(value, set);
                }
                set.set((zPos + z & 0x1F) * 32 + (xPos + x & 0x1F));
            }
        }
        return result;
    }

    static boolean isNotInRange(int x, int y, int minRadius, int maxRadius) {
        long distance = x * x + y * y;
        return distance >= (long)(maxRadius * maxRadius) && distance < (long)(minRadius * minRadius);
    }

    static boolean isNotInReach(int x, int y, int radius) {
        return x * x + y * y >= radius * radius;
    }
}

