/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures.nbt;

import com.google.common.collect.Iterables;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.tile.XUTile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTSerializer<T> {
    private static HashMap<Class<?>, NBTSerializer<?>> clazzMap = new HashMap();
    public final List<NBTSerializerEntry<? super T>> serializers = new ArrayList<NBTSerializerEntry<? super T>>();
    public final Iterable<NBTSerializerEntry<? super T>> iterable;

    public NBTSerializer(NBTSerializer<? super T> parent) {
        this.iterable = parent != null ? Iterables.concat(parent.iterable, this.serializers) : this.serializers;
    }

    @Nonnull
    public static <T, K extends NBTBase> BiConsumer<T, NBTBase> convertSetterSerializable(Function<T, INBTSerializable<K>> nbtSerializable) {
        return (t, nbtBase) -> ((INBTSerializable)nbtSerializable.apply(t)).deserializeNBT(nbtBase);
    }

    @Nonnull
    public static <T, K extends NBTBase> Function<T, NBTBase> convertGetterSerializable(Function<T, INBTSerializable<K>> nbtSerializable) {
        return t -> ((INBTSerializable)nbtSerializable.apply(t)).serializeNBT();
    }

    public static <T extends XUTile> NBTSerializer<T> getXUTileNBT(Class<T> clazz) {
        return NBTSerializer.getClassSerializer(clazz, XUTile.class);
    }

    public static <T> NBTSerializer<T> getClassSerializer(Class<T> clazz, Class<?> baseParentClass) {
        NBTSerializer<Object> nbtSerializer = clazzMap.get(clazz);
        if (nbtSerializer == null) {
            nbtSerializer = clazz == baseParentClass ? new NBTSerializer<T>(null) : new NBTSerializer<T>(NBTSerializer.getClassSerializer(clazz.getSuperclass(), baseParentClass));
            clazzMap.put(clazz, nbtSerializer);
        }
        return nbtSerializer;
    }

    public void readFromNBT(T t, NBTTagCompound tag) {
        for (NBTSerializerEntry<? super T> nBTSerializerEntry : this.iterable) {
            if (!(nBTSerializerEntry.expectedType == -1 ? tag.func_74764_b(nBTSerializerEntry.key) : tag.func_150297_b(nBTSerializerEntry.key, nBTSerializerEntry.expectedType))) continue;
            NBTBase base = tag.func_74781_a(nBTSerializerEntry.key);
            nBTSerializerEntry.setter.accept(t, base);
        }
    }

    public NBTTagCompound writeToNBT(T t, NBTTagCompound tag) {
        for (NBTSerializerEntry<? super T> nBTSerializerEntry : this.iterable) {
            NBTBase apply;
            try {
                apply = nBTSerializerEntry.getter.apply(t);
            }
            catch (Exception err) {
                err.printStackTrace();
                continue;
            }
            tag.func_74782_a(nBTSerializerEntry.key, apply);
        }
        return tag;
    }

    private NBTSerializer<T> registerEntry(NBTSerializerEntry<T> entry2) {
        for (NBTSerializerEntry<? super T> nBTSerializerEntry : this.iterable) {
            if (!nBTSerializerEntry.key.equals(entry2.key)) continue;
            throw new IllegalStateException("Duplicate key: " + nBTSerializerEntry.key);
        }
        this.serializers.add(entry2);
        return this;
    }

    public <K extends NBTBase> NBTSerializer<T> registerNBTSerializable(String key, Function<T, INBTSerializable<K>> nbtSerializable) {
        return this.registerEntry(new NBTSerializerEntry(key, NBTSerializer.convertGetterSerializable(nbtSerializable), NBTSerializer.convertSetterSerializable(nbtSerializable), -1));
    }

    public NBTSerializer<T> registerByte(String key, ToByteFunction<T> getter, ObjByteConsumer<T> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagByte(getter.applyAsByte(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagByte)nbtBase).func_150290_f()), 1));
    }

    public NBTSerializer<T> registerShort(String key, ToShortFunction<T> getter, ObjShortConsumer<T> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagShort(getter.applyAsShort(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagShort)nbtBase).func_150289_e()), 2));
    }

    public NBTSerializer<T> registerInt(String key, ToIntFunction<T> getter, ObjIntConsumer<T> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagInt(getter.applyAsInt(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagInt)nbtBase).func_150287_d()), 3));
    }

    public NBTSerializer<T> registerFloat(String key, ToFloatFunction<T> getter, ObjFloatConsumer<T> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagFloat(getter.applyAsFloat(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagFloat)nbtBase).func_150288_h()), 5));
    }

    public NBTSerializer<T> registerLong(String key, ToLongFunction<T> getter, ObjLongConsumer<T> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagLong(getter.applyAsLong(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagLong)nbtBase).func_150291_c()), 4));
    }

    public NBTSerializer<T> registerDouble(String key, ToDoubleFunction<T> getter, ObjDoubleConsumer<T> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagDouble(getter.applyAsDouble(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagDouble)nbtBase).func_150286_g()), 6));
    }

    public NBTSerializer<T> registerByteArray(String key, Function<T, byte[]> getter, BiConsumer<T, byte[]> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagByteArray((byte[])getter.apply(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagByteArray)nbtBase).func_150292_c()), 7));
    }

    public NBTSerializer<T> registerIntArray(String key, Function<T, int[]> getter, BiConsumer<T, int[]> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagIntArray((int[])getter.apply(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagIntArray)nbtBase).func_150302_c()), 11));
    }

    public NBTSerializer<T> registerString(String key, Function<T, String> getter, BiConsumer<T, String> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, obj -> new NBTTagString((String)getter.apply(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagString)nbtBase).func_150285_a_()), 8));
    }

    public NBTSerializer<T> registerNBTTagCompound(String key, Function<T, NBTTagCompound> getter, BiConsumer<T, NBTTagCompound> setter) {
        return this.registerEntry(new NBTSerializerEntry(key, getter::apply, (t, nbtBase) -> setter.accept(t, (NBTTagCompound)nbtBase), 10));
    }

    public NBTSerializer<T> registerBlockPos(String key, Function<T, BlockPos> getter, BiConsumer<T, BlockPos> setter) {
        return this.registerLong(key, value -> ((BlockPos)getter.apply(value)).func_177986_g(), (t, value) -> setter.accept(t, BlockPos.func_177969_a((long)value)));
    }

    public NBTSerializer<T> registerItemStack(String key, Function<T, ItemStack> getter, BiConsumer<T, ItemStack> setter) {
        return this.registerNBTTagCompound(key, t -> ((ItemStack)getter.apply(t)).func_77955_b(new NBTTagCompound()), (t, nbtTagCompound) -> setter.accept(t, StackHelper.loadFromNBT(nbtTagCompound)));
    }

    public <E, K extends NBTBase> NBTSerializer<T> registerCollection(String key, Function<T, Collection<E>> getter, Function<E, K> writer, Function<K, E> reader, int expectedID) {
        return this.registerEntry(new NBTSerializerEntry(key, t -> {
            Collection collection = (Collection)getter.apply(t);
            NBTTagList list = new NBTTagList();
            for (Object e : collection) {
                list.func_74742_a((NBTBase)writer.apply(e));
            }
            return list;
        }, (t, nbtBase) -> {
            Collection collection = (Collection)getter.apply(t);
            collection.clear();
            NBTTagList list = (NBTTagList)nbtBase;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTBase base = list.func_179238_g(i);
                Object e = reader.apply(base);
                collection.add(e);
            }
        }, 9));
    }

    public NBTSerializer<T> registerBoolean(String key, Predicate<T> getter, BiConsumer<T, Boolean> setter) {
        return this.registerByte(key, o -> (byte)(getter.test(o) ? 1 : 0), (t, value) -> setter.accept(t, value != 0));
    }

    public NBTSerializer<T> registerSide(String key, Function<T, EnumFacing> getter, BiConsumer<T, EnumFacing> setter) {
        return this.registerInt(key, t -> ((EnumFacing)getter.apply(t)).ordinal(), (t, value) -> setter.accept(t, EnumFacing.values()[value]));
    }

    public <E extends Enum<E>> NBTSerializer<T> registerEnum(String key, Class<E> clazz, Function<T, E> getter, BiConsumer<T, E> setter) {
        return this.registerInt(key, t -> ((Enum)getter.apply(t)).ordinal(), (t, value) -> setter.accept(t, ((Enum[])clazz.getEnumConstants())[value]));
    }

    public NBTTagCompound serialize(T t) {
        return this.writeToNBT(t, new NBTTagCompound());
    }

    public void deserialize(T t, NBTTagCompound nbt) {
        this.readFromNBT(t, nbt);
    }

    private static class NBTSerializerEntry<T> {
        public final Function<? super T, NBTBase> getter;
        public final BiConsumer<? super T, NBTBase> setter;
        public final int expectedType;
        public final String key;

        private NBTSerializerEntry(String key, Function<T, NBTBase> getter, BiConsumer<T, NBTBase> setter, int expectedType) {
            this.key = key;
            this.getter = getter;
            this.setter = setter;
            this.expectedType = expectedType;
        }

        private NBTSerializerEntry(NBTSerializerEntry<? super T> toCopy) {
            this.key = toCopy.key;
            this.getter = toCopy.getter;
            this.setter = toCopy.setter;
            this.expectedType = toCopy.expectedType;
        }
    }

    public static interface ObjFloatConsumer<T> {
        public void accept(T var1, float var2);
    }

    public static interface ObjShortConsumer<T> {
        public void accept(T var1, short var2);
    }

    public static interface ObjByteConsumer<T> {
        public void accept(T var1, byte var2);
    }

    public static interface ToFloatFunction<T> {
        public float applyAsFloat(T var1);
    }

    public static interface ToShortFunction<T> {
        public short applyAsShort(T var1);
    }

    public static interface ToByteFunction<T> {
        public byte applyAsByte(T var1);
    }
}

