/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.registry;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.registry.ConduitTypeDefinition;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ConduitDefinition {
    @Nonnull
    private final ConduitTypeDefinition network;
    @Nonnull
    private final UUID conduitUUID;
    @Nonnull
    private final NNList<UUID> aliases = new NNList();
    @Nonnull
    private final Class<? extends IServerConduit> serverClass;
    @Nonnull
    private final Class<? extends IClientConduit> clientClass;

    public ConduitDefinition(@Nonnull ConduitTypeDefinition network, @Nonnull UUID conduitUUID, @Nonnull Class<? extends IServerConduit> serverClass, @Nonnull Class<? extends IClientConduit> clientClass) {
        this.network = network;
        this.conduitUUID = conduitUUID;
        this.serverClass = serverClass;
        this.clientClass = clientClass;
        this.aliases.add((Object)UUID.nameUUIDFromBytes(serverClass.getName().getBytes()));
        if (serverClass != clientClass) {
            this.aliases.add((Object)UUID.nameUUIDFromBytes(clientClass.getName().getBytes()));
        }
        network.addMember(this);
    }

    public <T extends IServerConduit & IClientConduit> ConduitDefinition(@Nonnull ConduitTypeDefinition network, @Nonnull UUID conduitUUID, @Nonnull Class<? extends T> serverClass) {
        this(network, conduitUUID, serverClass, serverClass);
    }

    @Nonnull
    public ConduitTypeDefinition getNetwork() {
        return this.network;
    }

    @Nonnull
    public UUID getUUID() {
        return this.conduitUUID;
    }

    @Nonnull
    public NNList<UUID> getAliases() {
        return this.aliases;
    }

    @Nonnull
    public Class<? extends IServerConduit> getServerClass() {
        return this.serverClass;
    }

    @Nonnull
    public Class<? extends IClientConduit> getClientClass() {
        return this.clientClass;
    }

    public int hashCode() {
        return this.conduitUUID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConduitDefinition other = (ConduitDefinition)obj;
        return this.conduitUUID.equals(other.conduitUUID);
    }
}

