/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.alloy;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.capacitor.CapacitorHelper;
import crazypants.enderio.base.machine.baselegacy.AbstractPoweredTaskEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.machine.interfaces.IPoweredTask;
import crazypants.enderio.base.machine.modes.IoMode;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.recipe.IMachineRecipe;
import crazypants.enderio.base.recipe.MachineLevel;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import crazypants.enderio.base.recipe.alloysmelter.VanillaSmeltingRecipe;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.AlloySmelterConfig;
import crazypants.enderio.machines.machine.alloy.OperatingMode;
import crazypants.enderio.machines.machine.alloy.OperatingProfile;
import crazypants.enderio.util.Prep;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

@Storable
public class TileAlloySmelter
extends AbstractPoweredTaskEntity
implements IPaintable.IPaintableTileEntity {
    @Nonnull
    protected final OperatingProfile operatingProfile;
    @Store
    @Nonnull
    protected OperatingMode mode = OperatingMode.ALL;

    public TileAlloySmelter() {
        this(((AlloySmelterConfig.Profile)((Object)AlloySmelterConfig.profileNormal.get())).get(), new SlotDefinition(3, 1), CapacitorKey.ALLOY_SMELTER_POWER_INTAKE, CapacitorKey.ALLOY_SMELTER_POWER_BUFFER, CapacitorKey.ALLOY_SMELTER_POWER_USE);
    }

    protected TileAlloySmelter(@Nonnull OperatingProfile operatingProfile, @Nonnull SlotDefinition slotDefinition, @Nonnull ICapacitorKey maxEnergyRecieved, @Nonnull ICapacitorKey maxEnergyStored, @Nonnull ICapacitorKey maxEnergyUsed) {
        super(slotDefinition, maxEnergyRecieved, maxEnergyStored, maxEnergyUsed);
        this.operatingProfile = operatingProfile;
    }

    @Override
    @Nonnull
    protected RecipeLevel getMachineLevel() {
        return MachineLevel.NORMAL;
    }

    @Nonnull
    public OperatingProfile getOperatingProfile() {
        return this.operatingProfile;
    }

    @Nonnull
    public OperatingMode getMode() {
        return this.operatingProfile.canSwitchProfiles() ? this.mode : this.operatingProfile.getOperatingMode();
    }

    public void setMode(@Nonnull OperatingMode mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.updateClients = true;
        }
    }

    @Override
    protected IMachineRecipe canStartNextTask(long nextSeed) {
        IMachineRecipe nextRecipe = null;
        if (this.getMode().doAlloyRecipes() && AlloyRecipeManager.getInstance().getRecipeForInputs(this.getMachineLevel(), this.getRecipeInputs()) != null) {
            nextRecipe = AlloyRecipeManager.getInstance();
        }
        if (nextRecipe == null && this.getMode().doFurnaceRecipes() && VanillaSmeltingRecipe.getInstance().isRecipe(this.getMachineLevel(), this.getRecipeInputs())) {
            nextRecipe = VanillaSmeltingRecipe.getInstance();
        }
        return nextRecipe != null && this.canInsertResult(nextSeed, nextRecipe) ? nextRecipe : null;
    }

    @Override
    public boolean isMachineItemValidForSlot(int slot, @Nonnull ItemStack itemstack) {
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        if (this.getStackInSlot(slot).func_77969_a(itemstack)) {
            return true;
        }
        if (this.getMode().doAlloyRecipes()) {
            NNList input = new NNList();
            for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
                input.add((Object)(i == slot ? itemstack : this.inventory[i]));
            }
            if (AlloyRecipeManager.getInstance().isValidRecipeComponents(this.getMachineLevel(), (NNList<ItemStack>)input)) {
                return true;
            }
        }
        if (this.getMode().doFurnaceRecipes()) {
            for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
                if (i == slot || !Prep.isValid(this.getStackInSlot(i)) || this.getStackInSlot(i).func_77969_a(itemstack)) continue;
                return false;
            }
            if (VanillaSmeltingRecipe.getInstance().isValidInput(this.getMachineLevel(), itemstack)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "alloysmelter";
    }

    public static class Enhanced
    extends TileAlloySmelter {
        public Enhanced() {
            super(((AlloySmelterConfig.Profile)((Object)AlloySmelterConfig.profileEnhancedAlloy.get())).get(), new SlotDefinition(3, 1, 1), CapacitorKey.ENHANCED_ALLOY_SMELTER_POWER_INTAKE, CapacitorKey.ENHANCED_ALLOY_SMELTER_POWER_BUFFER, CapacitorKey.ENHANCED_ALLOY_SMELTER_POWER_USE);
            this.setEfficiencyMultiplier(CapacitorKey.ENHANCED_ALLOY_SMELTER_POWER_EFFICIENCY);
        }

        @Override
        @Nonnull
        public ICapacitorData getCapacitorData() {
            return CapacitorHelper.increaseCapacitorLevel(super.getCapacitorData(), 1.0f);
        }

        @Override
        protected boolean shouldDoubleTick(@Nonnull IPoweredTask task, int usedEnergy) {
            double chance = this.getCapacitorData().getUnscaledValue(CapacitorKey.ENHANCED_ALLOY_SMELTER_DOUBLE_OP_CHANCE) * ((float)usedEnergy / task.getRequiredEnergy());
            if (this.random.nextDouble() < chance) {
                return true;
            }
            return super.shouldDoubleTick(task, usedEnergy);
        }

        @Override
        public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode modeIn) {
            return (faceHit != EnumFacing.UP || modeIn == IoMode.NONE) && super.supportsMode(faceHit, modeIn);
        }

        @Override
        @Nonnull
        protected RecipeLevel getMachineLevel() {
            return MachineLevel.ADVANCED;
        }
    }

    public static class Furnace
    extends TileAlloySmelter {
        public Furnace() {
            super(((AlloySmelterConfig.Profile)((Object)AlloySmelterConfig.profileSimpleFurnace.get())).get(), new SlotDefinition(3, 1, 0), CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_INTAKE, CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_BUFFER, CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_USE);
            this.setEnergyLoss(CapacitorKey.SIMPLE_STIRLING_POWER_LOSS);
        }

        @Override
        @Nonnull
        protected RecipeLevel getMachineLevel() {
            return MachineLevel.SIMPLE;
        }
    }

    public static class Simple
    extends TileAlloySmelter {
        public Simple() {
            super(((AlloySmelterConfig.Profile)((Object)AlloySmelterConfig.profileSimpleAlloy.get())).get(), new SlotDefinition(3, 1, 0), CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_INTAKE, CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_BUFFER, CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_USE);
            this.setEnergyLoss(CapacitorKey.SIMPLE_ALLOY_SMELTER_POWER_LOSS);
        }

        @Override
        @Nonnull
        protected RecipeLevel getMachineLevel() {
            return MachineLevel.SIMPLE;
        }
    }
}

