/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.generator.stirling;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.machines.machine.generator.stirling.TileStirlingGenerator;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBurnTime
extends MessageTileEntity<TileStirlingGenerator> {
    public int burnTime;
    public int totalBurnTime;
    public boolean isLavaFired;

    public PacketBurnTime() {
    }

    public PacketBurnTime(@Nonnull TileStirlingGenerator tile) {
        super((TileEntity)tile);
        this.burnTime = tile.burnTime;
        this.totalBurnTime = tile.totalBurnTime;
        this.isLavaFired = tile.isLavaFired;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.burnTime);
        buf.writeInt(this.totalBurnTime);
        buf.writeBoolean(this.isLavaFired);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.burnTime = buf.readInt();
        this.totalBurnTime = buf.readInt();
        this.isLavaFired = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketBurnTime, IMessage> {
        public IMessage onMessage(PacketBurnTime message, MessageContext ctx) {
            TileStirlingGenerator tile;
            EntityPlayer player = EnderIO.proxy.getClientPlayer();
            if (player != null && (tile = (TileStirlingGenerator)message.getTileEntity(player.field_70170_p)) != null) {
                tile.burnTime = message.burnTime;
                tile.totalBurnTime = message.totalBurnTime;
                tile.isLavaFired = message.isLavaFired;
            }
            return null;
        }
    }
}

