/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.powertools.machine.capbank.network;

import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.power.IPowerStorage;
import crazypants.enderio.powertools.machine.capbank.CapBankType;
import crazypants.enderio.powertools.machine.capbank.InfoDisplayType;
import crazypants.enderio.powertools.machine.capbank.TileCapBank;
import crazypants.enderio.powertools.machine.capbank.network.EnergyReceptor;
import crazypants.enderio.powertools.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.powertools.machine.capbank.network.NetworkState;
import crazypants.enderio.powertools.machine.capbank.packet.PacketNetworkEnergyRequest;
import crazypants.enderio.powertools.machine.capbank.packet.PacketNetworkStateRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CapBankClientNetwork
implements ICapBankNetwork {
    private final int id;
    @Nonnull
    private final Map<BlockPos, TileCapBank> members = new HashMap<BlockPos, TileCapBank>();
    private int maxEnergySent;
    private int maxEnergyRecieved;
    private int stateUpdateCount;
    private int maxIO;
    private long maxEnergyStored;
    private long energyStored;
    @Nonnull
    private RedstoneControlMode inputControlMode = RedstoneControlMode.IGNORE;
    @Nonnull
    private RedstoneControlMode outputControlMode = RedstoneControlMode.IGNORE;
    private float avgInput;
    private float avgOutput;
    private long lastPowerRequestTick = -1L;
    private Map<DisplayInfoKey, IOInfo> ioDisplayInfoCache;

    public CapBankClientNetwork(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void requestPowerUpdate(@Nonnull TileCapBank capBank, int interval) {
        long curTick = EnderIO.proxy.getTickCount();
        if (this.lastPowerRequestTick == -1L || curTick - this.lastPowerRequestTick >= (long)interval) {
            if (this.stateUpdateCount == 0) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(capBank));
            } else {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkEnergyRequest(capBank));
            }
            this.lastPowerRequestTick = curTick;
        }
    }

    public void setState(@Nonnull NetworkState state) {
        this.maxEnergyRecieved = state.getMaxInput();
        this.maxEnergySent = state.getMaxOutput();
        this.maxIO = state.getMaxIO();
        this.maxEnergyStored = state.getMaxEnergyStored();
        this.energyStored = state.getEnergyStored();
        this.inputControlMode = state.getInputMode();
        this.outputControlMode = state.getOutputMode();
        this.avgInput = state.getAverageInput();
        this.avgOutput = state.getAverageOutput();
        ++this.stateUpdateCount;
    }

    public int getStateUpdateCount() {
        return this.stateUpdateCount;
    }

    public void setStateUpdateCount(int stateUpdateCount) {
        this.stateUpdateCount = stateUpdateCount;
    }

    @Override
    public void addMember(@Nonnull TileCapBank capBank) {
        this.members.put(capBank.getLocation(), capBank);
        this.invalidateDisplayInfoCache();
    }

    @Override
    @Nonnull
    public Collection<TileCapBank> getMembers() {
        return this.members.values();
    }

    @Override
    public void destroyNetwork() {
        for (TileCapBank cb : this.members.values()) {
            cb.setNetworkId(-1);
            cb.setNetwork(null);
        }
        this.invalidateDisplayInfoCache();
    }

    @Override
    public int getMaxIO() {
        return this.maxIO;
    }

    @Override
    public long getMaxEnergyStoredL() {
        return this.maxEnergyStored;
    }

    public void setMaxEnergyStoredL(long maxEnergyStored) {
        this.maxEnergyStored = maxEnergyStored;
    }

    public void setEnergyStored(long energyStored) {
        this.energyStored = energyStored;
    }

    @Override
    public long getEnergyStoredL() {
        return this.energyStored;
    }

    @Override
    public int getMaxOutput() {
        return this.maxEnergySent;
    }

    @Override
    public void setMaxOutput(int max) {
        this.maxEnergySent = MathHelper.func_76125_a((int)max, (int)0, (int)this.maxIO);
    }

    @Override
    public int getMaxInput() {
        return this.maxEnergyRecieved;
    }

    @Override
    public void setMaxInput(int max) {
        this.maxEnergyRecieved = MathHelper.func_76125_a((int)max, (int)0, (int)this.maxIO);
    }

    public double getEnergyStoredRatio() {
        if (this.getMaxEnergyStoredL() <= 0L) {
            return 0.0;
        }
        return (double)this.getEnergyStoredL() / (double)this.getMaxEnergyStoredL();
    }

    @Override
    @Nonnull
    public RedstoneControlMode getInputControlMode() {
        return this.inputControlMode;
    }

    @Override
    public void setInputControlMode(@Nonnull RedstoneControlMode inputControlMode) {
        this.inputControlMode = inputControlMode;
    }

    @Override
    @Nonnull
    public RedstoneControlMode getOutputControlMode() {
        return this.outputControlMode;
    }

    @Override
    public void setOutputControlMode(@Nonnull RedstoneControlMode outputControlMode) {
        this.outputControlMode = outputControlMode;
    }

    @Override
    public float getAverageChangePerTick() {
        return this.avgInput - this.avgOutput;
    }

    @Override
    public float getAverageInputPerTick() {
        return this.avgInput;
    }

    @Override
    public float getAverageOutputPerTick() {
        return this.avgOutput;
    }

    public void setAverageIOPerTick(float input, float output) {
        this.avgInput = input;
        this.avgOutput = output;
    }

    @Override
    @Nonnull
    public NetworkState getState() {
        return new NetworkState(this);
    }

    @Override
    public int addEnergy(int energy) {
        return energy;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public void removeReceptors(@Nonnull Collection<EnergyReceptor> receptors) {
    }

    @Override
    public void addReceptors(@Nonnull Collection<EnergyReceptor> receptors) {
    }

    @Override
    public void updateRedstoneSignal(@Nonnull TileCapBank tileCapBank, boolean recievingSignal) {
    }

    @Override
    public boolean isOutputEnabled() {
        return true;
    }

    @Override
    public boolean isInputEnabled() {
        return true;
    }

    @Override
    public IPowerStorage getController() {
        return this;
    }

    @Override
    public boolean isOutputEnabled(@Nonnull EnumFacing direction) {
        return this.isOutputEnabled();
    }

    @Override
    public boolean isInputEnabled(@Nonnull EnumFacing direction) {
        return this.isInputEnabled();
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    @Override
    public boolean isNetworkControlledIo(@Nonnull EnumFacing direction) {
        return true;
    }

    @Override
    public void invalidateDisplayInfoCache() {
        this.ioDisplayInfoCache = null;
    }

    @Nonnull
    public IOInfo getIODisplayInfo(@Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.getIODisplayInfo(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), face);
    }

    @Nonnull
    public IOInfo getIODisplayInfo(int x, int y, int z, @Nonnull EnumFacing face) {
        IOInfo value;
        DisplayInfoKey key = new DisplayInfoKey(x, y, z, face);
        if (this.ioDisplayInfoCache == null) {
            this.ioDisplayInfoCache = new HashMap<DisplayInfoKey, IOInfo>();
        }
        if ((value = this.ioDisplayInfoCache.get(key)) == null) {
            value = this.computeIODisplayInfo(x, y, z, face);
            this.ioDisplayInfoCache.put(key, value);
        }
        return value;
    }

    @Nonnull
    private IOInfo computeIODisplayInfo(int xOrg, int yOrg, int zOrg, @Nonnull EnumFacing dir) {
        int i;
        if (dir.func_96559_d() != 0) {
            return IOInfo.SINGLE;
        }
        TileCapBank cb = this.getCapBankAt(xOrg, yOrg, zOrg);
        if (cb == null) {
            return IOInfo.SINGLE;
        }
        CapBankType type = cb.getType();
        EnumFacing left = dir.func_176735_f();
        EnumFacing right = left.func_176734_d();
        int hOff = 0;
        int vOff = 0;
        while (this.isIOType(xOrg + left.func_82601_c(), yOrg, zOrg + left.func_82599_e(), dir, type)) {
            xOrg += left.func_82601_c();
            zOrg += left.func_82599_e();
            ++hOff;
        }
        while (this.isIOType(xOrg, yOrg + 1, zOrg, dir, type)) {
            ++yOrg;
            ++vOff;
        }
        if (this.isIOType(xOrg + left.func_82601_c(), yOrg, zOrg + left.func_82599_e(), dir, type)) {
            return IOInfo.SINGLE;
        }
        int width = 1;
        int height = 1;
        int xTmp = xOrg;
        int yTmp = yOrg;
        int zTmp = zOrg;
        while (this.isIOType(xTmp + right.func_82601_c(), yTmp, zTmp + right.func_82599_e(), dir, type)) {
            if (this.isIOType(xTmp + right.func_82601_c(), yTmp + 1, zTmp + right.func_82599_e(), dir, type)) {
                return IOInfo.SINGLE;
            }
            xTmp += right.func_82601_c();
            zTmp += right.func_82599_e();
            ++width;
        }
        while (this.isIOType(xOrg, yTmp - 1, zOrg, dir, type)) {
            xTmp = xOrg;
            zTmp = zOrg;
            if (this.isIOType(xTmp + left.func_82601_c(), --yTmp, zTmp + left.func_82599_e(), dir, type)) {
                return IOInfo.SINGLE;
            }
            for (i = 1; i < width; ++i) {
                if (this.isIOType(xTmp += right.func_82601_c(), yTmp, zTmp += right.func_82599_e(), dir, type)) continue;
                return IOInfo.SINGLE;
            }
            if (this.isIOType(xTmp + right.func_82601_c(), yTmp, zTmp + right.func_82599_e(), dir, type)) {
                return IOInfo.SINGLE;
            }
            ++height;
        }
        xTmp = xOrg;
        --yTmp;
        zTmp = zOrg;
        for (i = 0; i < width; ++i) {
            if (this.isIOType(xTmp, yTmp, zTmp, dir, type)) {
                return IOInfo.SINGLE;
            }
            xTmp += right.func_82601_c();
            zTmp += right.func_82599_e();
        }
        if (width == 1 && height == 1) {
            return IOInfo.SINGLE;
        }
        if (hOff > 0 || vOff > 0) {
            return IOInfo.INSIDE;
        }
        return new IOInfo(width, height);
    }

    private boolean isIOType(int x, int y, int z, @Nonnull EnumFacing face, @Nonnull CapBankType type) {
        TileCapBank cb = this.getCapBankAt(x, y, z);
        return cb != null && type == cb.getType() && cb.getDisplayType(face) == InfoDisplayType.IO;
    }

    @Nullable
    private TileCapBank getCapBankAt(int x, int y, int z) {
        return this.members.get(new BlockPos(x, y, z));
    }

    @Override
    public int getAverageIOPerTick() {
        return Math.round(this.getAverageChangePerTick());
    }

    public static class IOInfo {
        public final int width;
        public final int height;
        @Nonnull
        static final IOInfo SINGLE = new IOInfo(1, 1);
        @Nonnull
        static final IOInfo INSIDE = new IOInfo(0, 0);

        IOInfo(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public boolean isInside() {
            return this.width == 0;
        }
    }

    public static final class DisplayInfoKey {
        final int x;
        final int y;
        final int z;
        @Nonnull
        final EnumFacing face;

        public DisplayInfoKey(int x, int y, int z, @Nonnull EnumFacing face) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.face = face;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + this.x;
            hash = 97 * hash + this.y;
            hash = 97 * hash + this.z;
            hash = 97 * hash + this.face.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DisplayInfoKey)) {
                return false;
            }
            DisplayInfoKey other = (DisplayInfoKey)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z && this.face == other.face;
        }
    }
}

