/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.helper;

import io.github.phantamanta44.libnine.item.L9ItemSubs;
import io.github.phantamanta44.libnine.util.IDisplayableMatcher;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUtils {
    public static final short WILDCARD_META = Short.MAX_VALUE;

    public static boolean matchesWithWildcard(ItemStack a, ItemStack b) {
        return a.func_77973_b().equals(b.func_77973_b()) && (a.func_77960_j() == Short.MAX_VALUE || b.func_77960_j() == Short.MAX_VALUE || a.func_77960_j() == b.func_77960_j()) && (a.func_77942_o() ? b.func_77942_o() && b.func_77978_p().equals((Object)a.func_77978_p()) : !b.func_77942_o());
    }

    public static IDisplayableMatcher<ItemStack> matchesWithWildcard(ItemStack stack) {
        return IDisplayableMatcher.of(() -> stack.func_77960_j() == Short.MAX_VALUE ? new ItemStack(stack.func_77973_b(), stack.func_190916_E(), 0) : stack, s -> ItemUtils.matchesWithWildcard(stack, s));
    }

    public static String getColouredName(ItemStack stack) {
        return stack.func_77973_b().getForgeRarity(stack).getColor() + stack.func_82833_r();
    }

    public static String getUnlocalizedBlockName(WorldBlockPos pos) {
        ItemStack stack = pos.getBlock().getPickBlock(pos.getBlockState(), null, pos.getWorld(), pos.getPos(), null);
        return stack.func_77977_a();
    }

    public static String getLocalizedBlockName(WorldBlockPos pos) {
        ItemStack stack = pos.getBlock().getPickBlock(pos.getBlockState(), null, pos.getWorld(), pos.getPos(), null);
        return stack.func_77973_b().func_77653_i(stack);
    }

    public static String getColouredBlockName(WorldBlockPos pos) {
        return ItemUtils.getColouredName(pos.getBlock().getPickBlock(pos.getBlockState(), null, pos.getWorld(), pos.getPos(), null));
    }

    public static String getLocalizedSubName(L9ItemSubs item, int meta) {
        return I18n.func_74838_a((String)String.format("item.%s%d.name", item.getRegistryName(), meta));
    }

    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    public static void getStackTooltip(ItemStack stack, List<String> tooltip, @Nullable EntityPlayer player, ITooltipFlag tooltipFlags) {
        List itemTooltip = stack.func_82840_a(player, tooltipFlags);
        if (itemTooltip.isEmpty()) {
            tooltip.add(stack.func_77973_b().getForgeRarity(stack).getColor() + stack.func_82833_r());
            return;
        }
        Iterator iter = itemTooltip.iterator();
        tooltip.add(stack.func_77973_b().getForgeRarity(stack).getColor() + (String)iter.next());
        while (iter.hasNext()) {
            tooltip.add(TextFormatting.GRAY + (String)iter.next());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void getStackTooltip(ItemStack stack, List<String> tooltip, ITooltipFlag tooltipFlags) {
        ItemUtils.getStackTooltip(stack, tooltip, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, tooltipFlags);
    }

    public static ItemStack getItemForBlock(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        return new ItemStack(item, 1, item.func_77647_b(block.func_176201_c(state)));
    }
}

