/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.cmdscheduler.command.create;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.mcsimonflash.sponge.cmdcontrol.core.CmdUtils;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Aliases;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Children;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Command;
import com.mcsimonflash.sponge.cmdcontrol.teslalibs.command.Permission;
import com.mcsimonflash.sponge.cmdscheduler.CmdScheduler;
import com.mcsimonflash.sponge.cmdscheduler.command.Base;
import com.mcsimonflash.sponge.cmdscheduler.command.create.Calendar;
import com.mcsimonflash.sponge.cmdscheduler.command.create.Classic;
import com.mcsimonflash.sponge.cmdscheduler.command.create.Cron;
import com.mcsimonflash.sponge.cmdscheduler.internal.Config;
import com.mcsimonflash.sponge.cmdscheduler.schedule.Schedule;
import com.mcsimonflash.sponge.cmdscheduler.task.CommandTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.util.Tristate;

@Aliases(value={"create"})
@Permission(value="cmdscheduler.command.create.base")
@Children(value={Calendar.class, Classic.class, Cron.class})
public class Create
extends Command {
    public static final Text NAME_ARG = CmdUtils.arg((boolean)true, (String)"name", (Text)CmdUtils.info((String)"Name", (String)"The name of the task.\n", (String)"String", (String)"", (String)""));
    public static final Text COMMAND_ARG = CmdUtils.arg((boolean)true, (String)"command", (Text)CmdUtils.info((String)"Command", (String)"The command of the task.\n", (String)"Command", (String)"", (String)""));
    public static final Text START_FLAG = CmdUtils.arg((boolean)false, (String)"-start", (Text)CmdUtils.info((String)"Start", (String)"If defined, starts the task once created.\n", (String)"", (String)"-start", (String)""));
    public static final Text ASYNC_FLAG = CmdUtils.arg((boolean)false, (String)"-async", (Text)CmdUtils.info((String)"Async", (String)"If set to false, the task is processed synchronously.\n", (String)"Boolean\n", (String)"-async, -a", (String)""));

    @Inject
    private Create(Command.Settings settings) {
        super(settings.usage(CmdUtils.usage((String)"/cmdscheduler create ", (Text)CmdUtils.info((String)"Create", (String)"Creates a new task. The task is not saved to the config.\n", (String)"", (String)"create\n", (String)"cmdscheduler.command.create.base"), (Text[])new Text[]{CmdUtils.arg((boolean)true, (String)"...", (Text)CmdUtils.info((String)"Subcommand", (String)"One of Create's subcommands.\n", (String)"calendar, classic, cron", (String)"", (String)""))})));
    }

    public CommandResult execute(CommandSource src, CommandContext args) {
        PaginationList.builder().padding(Text.of((Object[])new Object[]{TextColors.GRAY, "="})).title(CmdScheduler.get().getPrefix()).contents((Iterable)Stream.concat(Stream.of(this), this.getChildren().stream()).map(Command::getUsage).collect(Collectors.toList())).footer(Base.LINKS).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    public static CommandResult create(CommandSource src, CommandContext args, Function<CommandContext, Schedule> function) throws CommandException {
        String name = (String)args.getOne("name").get();
        if (Config.tasks.containsKey(name.toLowerCase())) {
            throw new CommandException(CmdScheduler.getMessage(src, "cmdscheduler.command.create.already-exists", "name", name));
        }
        try {
            CommandTask task = new CommandTask(name, Lists.newArrayList((Object[])new String[]{(String)args.getOne("command").get()}), function.apply(args), args.getOne("async").orElse(Tristate.UNDEFINED));
            Config.tasks.put(task.getName().toLowerCase(), task);
            src.sendMessage(CmdScheduler.getMessage(src, "cmdscheduler.command.create.success", "task", task.getName()));
            if (args.hasAny("start")) {
                task.getTask().start(CmdScheduler.get().getContainer());
                src.sendMessage(CmdScheduler.getMessage(src, "cmdscheduler.command.create.started", "task", task.getName()));
            }
            return CommandResult.success();
        }
        catch (IllegalArgumentException e) {
            throw new CommandException(CmdScheduler.get().getPrefix().concat(CmdUtils.toText((String)("&7" + e.getMessage()))));
        }
    }
}

