/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.listeners;

import com.flowpowered.math.vector.Vector3d;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.managers.ProtectionResult;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.listeners.AbstractListener;
import java.util.Optional;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.ArmorStand;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class PlayerInteractListener
extends AbstractListener {
    public PlayerInteractListener(EagleFactions plugin) {
        super(plugin);
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onItemUse(InteractItemEvent event, @Root Player player) {
        ProtectionResult protectionResult;
        if (event.getItemStack() == ItemStackSnapshot.NONE) {
            return;
        }
        Vector3d interactionPoint = event.getInteractionPoint().orElse(player.getLocation().getPosition());
        Location location = new Location((Extent)player.getWorld(), interactionPoint);
        if (location.getBlockType() == BlockTypes.AIR) {
            return;
        }
        boolean hasHitEntity = event.getContext().containsKey(EventContextKeys.ENTITY_HIT);
        if (hasHitEntity) {
            Entity hitEntity = (Entity)event.getContext().get(EventContextKeys.ENTITY_HIT).get();
            if (hitEntity instanceof Living && !(hitEntity instanceof ArmorStand)) {
                return;
            }
            location = hitEntity.getLocation();
        }
        if (!(protectionResult = super.getPlugin().getProtectionManager().canUseItem((Location<World>)location, (User)player, event.getItemStack(), true)).hasAccess()) {
            event.setCancelled(true);
            return;
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onEntityInteract(InteractEntityEvent event, @Root Player player) {
        Entity targetEntity = event.getTargetEntity();
        Optional optionalInteractionPoint = event.getInteractionPoint();
        if (targetEntity instanceof Living && !(targetEntity instanceof ArmorStand)) {
            return;
        }
        Vector3d blockPosition = optionalInteractionPoint.orElseGet(() -> targetEntity.getLocation().getPosition());
        Location location = new Location((Extent)targetEntity.getWorld(), blockPosition);
        boolean canInteractWithEntity = super.getPlugin().getProtectionManager().canInteractWithBlock((Location<World>)location, (User)player, true).hasAccess();
        if (!canInteractWithEntity) {
            event.setCancelled(true);
            return;
        }
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onBlockInteract(InteractBlockEvent.Secondary event, @Root Player player) {
        if (event.getTargetBlock() == BlockSnapshot.NONE || event.getTargetBlock().getState().getType() == BlockTypes.AIR) {
            return;
        }
        event.getTargetBlock().getLocation().map(location -> super.getPlugin().getProtectionManager().canInteractWithBlock((Location<World>)location, (User)player, true)).ifPresent(protectionResult -> {
            if (!protectionResult.hasAccess()) {
                event.setCancelled(true);
            } else if (protectionResult.isEagleFeather()) {
                this.removeEagleFeather(player);
            }
        });
    }

    private void removeEagleFeather(Player player) {
        ItemStack feather = (ItemStack)player.getItemInHand(HandTypes.MAIN_HAND).get();
        feather.setQuantity(feather.getQuantity() - 1);
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.DARK_PURPLE, "You used Eagle's Feather!"}));
    }
}

