/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage.sql.h2;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLAbstractProvider;
import io.github.aquerr.eaglefactions.common.storage.sql.SQLProvider;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.sql.SqlService;

public class H2Provider
extends SQLAbstractProvider
implements SQLProvider {
    private static H2Provider INSTANCE = null;
    private final DataSource dataSource;

    public static H2Provider getInstance(EagleFactions eagleFactions) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new H2Provider(eagleFactions);
                return INSTANCE;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        }
        return INSTANCE;
    }

    private H2Provider(EagleFactions eagleFactions) throws SQLException {
        super(eagleFactions);
        Path databasePath = eagleFactions.getConfigDir().resolve("data/h2/" + this.getDatabaseName());
        SqlService sqlService = (SqlService)Sponge.getServiceManager().provideUnchecked(SqlService.class);
        this.dataSource = sqlService.getDataSource("jdbc:h2://" + super.getUsername() + ":" + super.getPassword() + "@" + databasePath);
        Connection connection = this.getConnection();
        connection.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public String getProviderName() {
        return "h2";
    }
}

