/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpclib.discordutils;

import java.time.OffsetDateTime;
import me.hypherionmc.simplerpclib.configuration.ClientConfig;
import me.hypherionmc.simplerpclib.discordutils.DiscordHandler;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceBuilder;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceCore;
import me.hypherionmc.simplerpclib.discordutils.RichPresenceState;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpclib.util.APIUtils;

public class RichPresenceEvents {
    private RichPresenceState rpcState = RichPresenceState.INIT;
    private boolean isSinglePlayer = false;
    private boolean isFirstJoin = true;
    private final RichPresenceCore core;

    public RichPresenceEvents(RichPresenceCore core) {
        this.core = core;
        this.initRPC();
    }

    private void initRPC() {
        this.rpcState = RichPresenceState.INIT;
        this.isFirstJoin = true;
        this.updateRPC();
    }

    public void ingameRPC(boolean isSingle) {
        this.rpcState = RichPresenceState.IN_GAME;
        this.isSinglePlayer = isSingle;
        this.updateRPC();
    }

    public void mainMenuRPC() {
        this.rpcState = RichPresenceState.MAIN_MENU;
        this.isFirstJoin = true;
        this.updateRPC();
    }

    public void serverListRPC() {
        this.rpcState = RichPresenceState.SERVER_MENU;
        this.isFirstJoin = true;
        this.updateRPC();
    }

    public void joiningGameRPC() {
        this.rpcState = RichPresenceState.JOINING_GAME;
        this.updateRPC();
    }

    public void joinGame() {
        if (this.isFirstJoin) {
            RichPresenceBuilder.offsetDateTime = OffsetDateTime.now();
            this.isFirstJoin = false;
        }
    }

    public void updateRPC() {
        ClientConfig clientConfig = this.core.getClientConfig();
        DiscordHandler discordHandler = this.core.getDiscordHandler();
        if (clientConfig != null && clientConfig.general.enabled && discordHandler != null) {
            if (this.rpcState == RichPresenceState.INIT) {
                if (clientConfig.init.getPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.init.getPresence(this.core).getPresence(false));
                } else {
                    this.genericRPC(this.core);
                }
            } else if (this.rpcState == RichPresenceState.MAIN_MENU) {
                if (clientConfig.main_menu.getPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.main_menu.getPresence(this.core).getPresence(false));
                } else {
                    this.genericRPC(this.core);
                }
            } else if (this.rpcState == RichPresenceState.SERVER_MENU) {
                if (clientConfig.server_list.getPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.server_list.getPresence(this.core).getPresence(false));
                } else {
                    this.genericRPC(this.core);
                }
            } else if (this.rpcState == RichPresenceState.JOINING_GAME) {
                if (clientConfig.join_game.getPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.join_game.getPresence(this.core).getPresence(false));
                } else {
                    this.genericRPC(this.core);
                }
            } else if (this.rpcState == RichPresenceState.IN_GAME) {
                if (this.isSinglePlayer) {
                    if (clientConfig.single_player.getPresence(this.core) != null) {
                        discordHandler.updateRichPresence(clientConfig.single_player.getPresence(this.core).getPresence(false));
                    } else {
                        this.genericRPC(this.core);
                    }
                } else if (clientConfig.multi_player.getPresence(this.core) != null) {
                    discordHandler.updateRichPresence(clientConfig.multi_player.getPresence(this.core).getPresence(false));
                } else {
                    this.genericRPC(this.core);
                }
            } else {
                this.genericRPC(this.core);
            }
        } else if (discordHandler != null) {
            discordHandler.updateRichPresence(null);
        }
    }

    public void genericRPC(RichPresenceCore core) {
        if (core.getClientConfig() != null && core.getClientConfig().general.enabled && core.getDiscordHandler() != null) {
            RichPresenceBuilder build = new RichPresenceBuilder().setDetails(core.getUtilHandler().parseVars(core.getClientConfig().generic.description)).setLargeImage(core.getClientConfig().generic.largeImageKey).setLargeImageText(core.getUtilHandler().parseVars(core.getClientConfig().generic.largeImageText)).setSmallImage(core.getClientConfig().generic.smallImageKey).setSmallImageText(core.getUtilHandler().parseVars(core.getClientConfig().generic.smallImageText)).setState(core.getUtilHandler().parseVars(core.getClientConfig().generic.state)).setButtons(APIUtils.parseButtons(core.getClientConfig().generic.buttonsList, core.getUtilHandler()));
            build = LauncherUtils.getLauncherOverrides(build, core);
            core.getDiscordHandler().updateRichPresence(build.getPresence(false));
        }
    }
}

