/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.tileentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cubex2.cs4.api.TileEntityModule;
import cubex2.cs4.api.TileEntityModuleSupplier;
import cubex2.cs4.plugins.vanilla.ContentTileEntitySimple;
import cubex2.cs4.plugins.vanilla.TileEntityRegistry;
import cubex2.cs4.plugins.vanilla.gui.FluidSource;
import cubex2.cs4.plugins.vanilla.gui.ItemHandlerSupplier;
import cubex2.cs4.plugins.vanilla.gui.ProgressBarSource;
import cubex2.cs4.plugins.vanilla.tileentity.CSTileEntity;
import cubex2.cs4.plugins.vanilla.tileentity.FieldSupplier;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TileEntitySimple
extends TileEntity
implements CSTileEntity<ContentTileEntitySimple>,
ItemHandlerSupplier,
FieldSupplier,
ProgressBarSource,
ITickable,
FluidSource {
    private final ContentTileEntitySimple content;
    private final LinkedHashMap<String, TileEntityModule> modules = Maps.newLinkedHashMap();

    public TileEntitySimple(String contentId) {
        this.content = (ContentTileEntitySimple)TileEntityRegistry.getContent(new ResourceLocation(contentId));
        this.createModules();
    }

    private void createModules() {
        for (Map.Entry entry : this.content.modules.entrySet()) {
            this.modules.put((String)entry.getKey(), ((TileEntityModuleSupplier)entry.getValue()).createModule(this));
        }
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        this.modules.values().forEach(m -> m.setWorld(worldIn));
    }

    @Override
    public ContentTileEntitySimple getContent() {
        return this.content;
    }

    public void func_73660_a() {
        this.modules.values().forEach(TileEntityModule::update);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (Map.Entry<String, TileEntityModule> entry : this.modules.entrySet()) {
            NBTTagCompound moduleNbt = compound.func_74775_l("Module_" + entry.getKey());
            TileEntityModule module = entry.getValue();
            module.readFromNBT(moduleNbt);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        for (Map.Entry<String, TileEntityModule> entry : this.modules.entrySet()) {
            TileEntityModule module = entry.getValue();
            NBTTagCompound moduleNbt = module.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("Module_" + entry.getKey(), (NBTBase)moduleNbt);
        }
        return super.func_189515_b(compound);
    }

    @Override
    public Optional<IItemHandler> getItemHandler(String name) {
        TileEntityModule module = this.modules.get(name);
        if (module != null) {
            return Optional.ofNullable(module.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return Optional.empty();
    }

    @Override
    public int getFieldCount() {
        return this.modules.values().stream().mapToInt(TileEntityModule::getFieldCount).sum();
    }

    @Override
    public int getField(int id) {
        return this.moduleForField(id).map(p -> ((TileEntityModule)p.getLeft()).getField((Integer)p.getRight())).orElse(0);
    }

    @Override
    public void setField(int id, int value) {
        this.moduleForField(id).ifPresent(p -> ((TileEntityModule)p.getLeft()).setField((Integer)p.getRight(), value));
    }

    private Optional<Pair<TileEntityModule, Integer>> moduleForField(int id) {
        for (TileEntityModule module : this.modules.values()) {
            if (id >= module.getFieldCount()) {
                id -= module.getFieldCount();
                continue;
            }
            return Optional.of(Pair.of((Object)module, (Object)id));
        }
        return Optional.empty();
    }

    @Override
    public float getProgress(String name) {
        String sourceName;
        String moduleName;
        if (name.contains(":")) {
            String[] split = name.split(":");
            moduleName = split[0];
            sourceName = split[1];
        } else {
            moduleName = name;
            sourceName = name;
        }
        TileEntityModule module = this.modules.get(moduleName);
        if (module instanceof ProgressBarSource) {
            return ((ProgressBarSource)((Object)module)).getProgress(sourceName);
        }
        return 0.0f;
    }

    @Override
    @Nullable
    public IFluidTank getFluidTank(String name) {
        String sourceName;
        String moduleName;
        if (name.contains(":")) {
            String[] split = name.split(":");
            moduleName = split[0];
            sourceName = split[1];
        } else {
            moduleName = name;
            sourceName = name;
        }
        TileEntityModule module = this.modules.get(moduleName);
        if (module instanceof FluidSource) {
            return ((FluidSource)((Object)module)).getFluidTank(sourceName);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        for (TileEntityModule module : this.modules.values()) {
            if (!module.hasCapability(capability, facing)) continue;
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getItemHandlerCapability(facing);
        }
        for (TileEntityModule module : this.modules.values()) {
            if (!module.hasCapability(capability, facing)) continue;
            return module.getCapability(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    private IItemHandlerModifiable getItemHandlerCapability(@Nullable EnumFacing facing) {
        Capability capability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        LinkedList handlers = Lists.newLinkedList();
        for (TileEntityModule module : this.modules.values()) {
            if (!module.hasCapability(capability, facing)) continue;
            handlers.add((IItemHandlerModifiable)module.getCapability(capability, facing));
        }
        if (handlers.size() == 1) {
            return (IItemHandlerModifiable)handlers.get(0);
        }
        if (handlers.size() > 1) {
            return new CombinedInvWrapper(handlers.toArray(new IItemHandlerModifiable[handlers.size()]));
        }
        return null;
    }
}

