/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.cout970.magneticraft.api.internal.registries.machines.crushingtable.CrushingTableRecipe;
import com.cout970.magneticraft.api.internal.registries.machines.crushingtable.CrushingTableRecipeManager;
import com.cout970.magneticraft.api.internal.registries.machines.grinder.GrinderRecipe;
import com.cout970.magneticraft.api.internal.registries.machines.grinder.GrinderRecipeManager;
import com.cout970.magneticraft.api.internal.registries.machines.sieve.SieveRecipe;
import com.cout970.magneticraft.api.internal.registries.machines.sieve.SieveRecipeManager;
import com.cout970.magneticraft.api.internal.registries.machines.sluicebox.SluiceBoxRecipe;
import com.cout970.magneticraft.api.internal.registries.machines.sluicebox.SluiceBoxRecipeManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import net.minecraft.item.ItemStack;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class MagneticraftIntegration
extends AbstractIntegrationThread {
    MagneticraftIntegration() {
        super("Magneticraft");
    }

    public String call() {
        try {
            this.fixCrushingTableRecipes();
            this.fixSluiceBoxRecipes();
            this.fixGrinderRecipes();
            this.fixSieveRecipe();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "Everything got Magnetized.";
    }

    private void fixCrushingTableRecipes() {
        List recipes = (List)Util.getField(CrushingTableRecipeManager.class, (String)"recipes", (Object)CrushingTableRecipeManager.INSTANCE, List.class);
        if (recipes != null) {
            recipes.replaceAll(iCrushingTableRecipe -> new CrushingTableRecipe(iCrushingTableRecipe.getInput(), this.resourceHandler.getMainItemStack(iCrushingTableRecipe.getOutput()), iCrushingTableRecipe.useOreDictionaryEquivalencies()));
        }
    }

    private void fixSluiceBoxRecipes() {
        List recipes = (List)Util.getField(SluiceBoxRecipeManager.class, (String)"recipes", (Object)SluiceBoxRecipeManager.INSTANCE, List.class);
        if (recipes == null) {
            return;
        }
        recipes.replaceAll(iSluiceBoxRecipe -> {
            ArrayList newOutputs = Lists.newArrayList((Iterable)iSluiceBoxRecipe.getOutputs());
            newOutputs.replaceAll(itemStackFloatPair -> new Pair((Object)this.resourceHandler.getMainItemStack((ItemStack)itemStackFloatPair.getFirst()), itemStackFloatPair.getSecond()));
            return new SluiceBoxRecipe(iSluiceBoxRecipe.getInput(), (List)newOutputs, iSluiceBoxRecipe.useOreDictionaryEquivalencies());
        });
    }

    private void fixGrinderRecipes() {
        List recipes = (List)Util.getField(GrinderRecipeManager.class, (String)"recipes", (Object)GrinderRecipeManager.INSTANCE, List.class);
        if (recipes != null) {
            recipes.replaceAll(iGrinderRecipe -> new GrinderRecipe(iGrinderRecipe.getInput(), this.resourceHandler.getMainItemStack(iGrinderRecipe.getPrimaryOutput()), this.resourceHandler.getMainItemStack(iGrinderRecipe.getSecondaryOutput()), iGrinderRecipe.getProbability(), iGrinderRecipe.getDuration(), iGrinderRecipe.useOreDictionaryEquivalencies()));
        }
    }

    private void fixSieveRecipe() {
        List recipes = (List)Util.getField(SieveRecipeManager.class, (String)"recipes", (Object)SieveRecipeManager.INSTANCE, List.class);
        if (recipes != null) {
            recipes.replaceAll(iSieveRecipe -> new SieveRecipe(iSieveRecipe.getInput(), this.resourceHandler.getMainItemStack(iSieveRecipe.getPrimary()), iSieveRecipe.getPrimaryChance(), this.resourceHandler.getMainItemStack(iSieveRecipe.getSecondary()), iSieveRecipe.getSecondaryChance(), this.resourceHandler.getMainItemStack(iSieveRecipe.getTertiary()), iSieveRecipe.getTertiaryChance(), iSieveRecipe.getDuration(), iSieveRecipe.useOreDictionaryEquivalencies()));
        }
    }
}

