/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.shop.Bank;
import com.carrot.carrotshop.shop.Buy;
import com.carrot.carrotshop.shop.Cmd;
import com.carrot.carrotshop.shop.DeviceOff;
import com.carrot.carrotshop.shop.DeviceOn;
import com.carrot.carrotshop.shop.Heal;
import com.carrot.carrotshop.shop.Sell;
import com.carrot.carrotshop.shop.Toggle;
import com.carrot.carrotshop.shop.Trade;
import com.carrot.carrotshop.shop.aBuy;
import com.carrot.carrotshop.shop.aDeviceOff;
import com.carrot.carrotshop.shop.aDeviceOn;
import com.carrot.carrotshop.shop.aSell;
import com.carrot.carrotshop.shop.aToggle;
import com.carrot.carrotshop.shop.aTrade;
import com.carrot.carrotshop.shop.iBuy;
import com.carrot.carrotshop.shop.iSell;
import com.carrot.carrotshop.shop.iTrade;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.item.EnchantmentData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.SignData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@ConfigSerializable
public abstract class Shop {
    @Setting
    private UUID owner = null;
    @Setting
    private Location<World> location = null;
    @Setting
    private Currency currency = null;

    public Shop() {
    }

    public Shop(Location<World> loc) {
        Optional tile = loc.getTileEntity();
        if (!tile.isPresent() || !((TileEntity)tile.get()).supports(SignData.class)) {
            throw new ExceptionInInitializerError("Improbable error: managed to trigger a shop creation event from something other than a sign");
        }
        this.location = loc;
    }

    public abstract void info(Player var1);

    public abstract boolean trigger(Player var1);

    public final void done(Player player) {
        if (this.canLoopCurrency(player)) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.SHOP_CURRENCY.replace("%name%", this.getCurrency().getDisplayName().toPlain())}));
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.GOLD, Lang.SHOP_CURRENCY_LOOP}));
        }
    }

    public boolean update() {
        this.setOK();
        return true;
    }

    public final boolean destroy(CommandSource player) {
        if (player instanceof Player && !this.isOwner((Player)player)) {
            return false;
        }
        this.setReset();
        ShopsData.delShop(this);
        return true;
    }

    public Location<World> getLocation() {
        return this.location;
    }

    public List<Location<World>> getLocations() {
        ArrayList<Location<World>> locations = new ArrayList<Location<World>>();
        locations.add(this.location);
        return locations;
    }

    public boolean canLoopCurrency(Player player) {
        return ShopsData.hasMultipleCurrencies() && this.isOwner(player) && player.hasPermission("carrotshop.setup.currency");
    }

    protected final void setOwner(Player player) {
        this.owner = player.getUniqueId();
    }

    protected final UUID getOwner() {
        return this.owner;
    }

    protected final boolean isOwner(Player player) {
        if (this.owner != null && this.owner.equals(player.getUniqueId())) {
            return true;
        }
        return player.hasPermission("carrotshop.admin.override");
    }

    protected final void setOK() {
        this.setFirstLineColor(TextColors.DARK_BLUE);
    }

    protected final void setFail() {
        this.setFirstLineColor(TextColors.RED);
    }

    public final void setReset() {
        this.setFirstLineColor(TextColors.RESET);
    }

    public final Currency getCurrency() {
        if (this.hasCurrency()) {
            return this.currency;
        }
        return ShopsData.getCurrency();
    }

    protected final Optional<Currency> getRawCurrency() {
        if (this.hasCurrency()) {
            return Optional.of(this.currency);
        }
        return Optional.empty();
    }

    public boolean hasCurrency() {
        return ShopsData.hasMultipleCurrencies() && this.currency != null;
    }

    public final void loopCurrency() {
        if (!ShopsData.hasMultipleCurrencies()) {
            return;
        }
        if (ShopsData.getCurrency().equals(this.currency)) {
            this.currency = null;
            return;
        }
        boolean takeNext = false;
        Currency first = null;
        if (this.currency == null) {
            this.currency = ShopsData.getCurrency();
        }
        for (Currency cur : CarrotShop.getEcoService().getCurrencies()) {
            if (first == null) {
                first = cur;
            }
            if (takeNext) {
                this.currency = cur;
                return;
            }
            if (!cur.equals(this.currency)) continue;
            takeNext = true;
        }
        this.currency = first;
    }

    protected final String formatPrice(float value) {
        return this.formatPrice(BigDecimal.valueOf(value));
    }

    protected final String formatPrice(BigDecimal value) {
        String str = value == BigDecimal.ZERO ? Lang.PRICE_ZERO : (value == BigDecimal.ONE ? Lang.PRICE_ONE : Lang.PRICE_DEFAULT);
        return str.replace("%value%", new DecimalFormat("#.##").format(value)).replace("%currencyFull%", this.getCurrency().getDisplayName().toPlain()).replace("%currencyFullPlural%", this.getCurrency().getPluralDisplayName().toPlain()).replace("%currencySymbol%", this.getCurrency().getSymbol().toPlain());
    }

    private final void setFirstLineColor(TextColor color) {
        Optional data;
        Optional sign = this.location.getTileEntity();
        if (sign.isPresent() && ((TileEntity)sign.get()).supports(SignData.class) && (data = ((TileEntity)sign.get()).getOrCreate(SignData.class)).isPresent()) {
            SignData signData = (SignData)data.get();
            signData.set((BaseValue)signData.lines().set(0, (Object)Text.of((Object[])new Object[]{color, ((Text)signData.lines().get(0)).toPlain()})));
            ((TileEntity)sign.get()).offer((ValueContainer)signData);
        }
    }

    public static void putItemInWorld(ItemStackSnapshot itemStackSnapshop, Location<World> spawnLocation) {
        Extent extent = spawnLocation.getExtent();
        Entity item = extent.createEntity(EntityTypes.ITEM, spawnLocation.getPosition());
        item.offer(Keys.REPRESENTED_ITEM, (Object)itemStackSnapshop);
        extent.spawnEntity(item);
    }

    protected static final float getPrice(Location<World> location) {
        Optional data;
        Optional sign = location.getTileEntity();
        if (sign.isPresent() && ((TileEntity)sign.get()).supports(SignData.class) && (data = ((TileEntity)sign.get()).get(SignData.class)).isPresent()) {
            String priceLine = ((Text)((SignData)data.get()).lines().get(3)).toPlain().replace(",", ".").replaceAll("[^\\d.]", "");
            if (priceLine.length() == 0) {
                return 0.0f;
            }
            return Float.parseFloat(new DecimalFormat("#.##").format(Float.parseFloat(priceLine)).replace(",", "."));
        }
        return -1.0f;
    }

    public static final Text getItemName(ItemStack itemStack) {
        Text displayName = (Text)itemStack.get(Keys.DISPLAY_NAME).orElse(Text.of((Translation)itemStack.getTranslation(), (Object[])new Object[0]));
        TextColor itemColor = displayName.getColor();
        if (!displayName.getChildren().isEmpty()) {
            itemColor = ((Text)displayName.getChildren().get(0)).getColor();
        }
        if (itemStack.get(EnchantmentData.class).isPresent()) {
            itemColor = TextColors.AQUA;
        }
        if (itemColor == TextColors.NONE) {
            itemColor = TextColors.DARK_AQUA;
        }
        return Text.of((Object[])new Object[]{itemColor, displayName.toPlain()});
    }

    public static final Text formatItemName(ItemStack itemStack) {
        return Text.builder().append(new Text[]{Text.of((Object[])new Object[]{TextColors.GRAY, "["}), Shop.getItemName(itemStack), Text.of((Object[])new Object[]{TextColors.GRAY, "]"})}).onHover((HoverAction)TextActions.showItem((ItemStackSnapshot)itemStack.createSnapshot())).build();
    }

    public static final Text formatInventoryNames(Inventory inventory) {
        Text.Builder builder = Text.builder();
        boolean more = false;
        for (Inventory item : inventory.slots()) {
            if (!item.peek().isPresent()) continue;
            if (more) {
                builder.append(new Text[]{Text.of((String)", ")});
            }
            builder.append(new Text[]{Text.of((Object[])new Object[]{Shop.formatItemName((ItemStack)item.peek().get()), TextColors.GRAY, " x ", TextColors.YELLOW, ((ItemStack)item.peek().get()).getQuantity()})});
            more = true;
        }
        return builder.build();
    }

    public static boolean hasEnough(Inventory inventory, Inventory needs) {
        for (Inventory item : needs.slots()) {
            Optional<ItemStack> template;
            if (!item.peek().isPresent() || (template = Shop.getTemplate(inventory, (ItemStack)item.peek().get())).isPresent() && inventory.query(new QueryOperation[]{QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of((Object)template.get())}).totalItems() >= needs.query(new QueryOperation[]{QueryOperationTypes.ITEM_STACK_IGNORE_QUANTITY.of(item.peek().get())}).totalItems()) continue;
            return false;
        }
        return true;
    }

    private static boolean equalTo(ItemStack item, ItemStack needle) {
        if (item.equalTo(needle)) {
            return true;
        }
        for (Map.Entry pair : needle.toContainer().getValues(true).entrySet()) {
            Optional other;
            if (!((DataQuery)pair.getKey()).toString().equals("ItemType") && !((DataQuery)pair.getKey()).toString().equals("UnsafeDamage") && !((DataQuery)pair.getKey()).toString().equals("UnsafeData.ench") && !((DataQuery)pair.getKey()).toString().equals("UnsafeData.StoredEnchantments") && !((DataQuery)pair.getKey()).toString().equals("UnsafeData.Potion") && !((DataQuery)pair.getKey()).toString().equals("UnsafeData.EntityTag") || (other = item.toContainer().get((DataQuery)pair.getKey())).isPresent() && pair.getValue().toString().equals(other.get().toString())) continue;
            return false;
        }
        return true;
    }

    public static Optional<ItemStack> getTemplate(Inventory inventory, ItemStack needle) {
        for (Inventory item : inventory.slots()) {
            if (!item.peek().isPresent() || !Shop.equalTo((ItemStack)item.peek().get(), needle)) continue;
            return item.peek();
        }
        return Optional.empty();
    }

    public static boolean build(Player player, Location<World> target) {
        Optional data;
        Optional sign = target.getTileEntity();
        if (sign.isPresent() && ((TileEntity)sign.get()).supports(SignData.class) && (data = ((TileEntity)sign.get()).get(SignData.class)).isPresent()) {
            Shop shop;
            SignData signData = (SignData)data.get();
            try {
                switch (((Text)signData.lines().get(0)).toPlain().toLowerCase()) {
                    case "[itrade]": {
                        shop = new iTrade(player, target);
                        break;
                    }
                    case "[ibuy]": {
                        if (CarrotShop.getEcoService() == null) {
                            return false;
                        }
                        shop = new iBuy(player, target);
                        break;
                    }
                    case "[isell]": {
                        if (CarrotShop.getEcoService() == null) {
                            return false;
                        }
                        shop = new iSell(player, target);
                        break;
                    }
                    case "[atrade]": {
                        shop = new aTrade(player, target);
                        break;
                    }
                    case "[abuy]": {
                        if (CarrotShop.getEcoService() == null) {
                            return false;
                        }
                        shop = new aBuy(player, target);
                        break;
                    }
                    case "[asell]": {
                        if (CarrotShop.getEcoService() == null) {
                            return false;
                        }
                        shop = new aSell(player, target);
                        break;
                    }
                    case "[trade]": {
                        shop = new Trade(player, target);
                        break;
                    }
                    case "[buy]": {
                        if (CarrotShop.getEcoService() == null) {
                            return false;
                        }
                        shop = new Buy(player, target);
                        break;
                    }
                    case "[sell]": {
                        if (CarrotShop.getEcoService() == null) {
                            return false;
                        }
                        shop = new Sell(player, target);
                        break;
                    }
                    case "[bank]": {
                        if (CarrotShop.getEcoService() == null) {
                            return false;
                        }
                        shop = new Bank(player, target);
                        break;
                    }
                    case "[heal]": {
                        shop = new Heal(player, target);
                        break;
                    }
                    case "[cmd]": {
                        shop = new Cmd(player, target);
                        break;
                    }
                    case "[deviceon]": {
                        shop = new DeviceOn(player, target);
                        break;
                    }
                    case "[deviceoff]": {
                        shop = new DeviceOff(player, target);
                        break;
                    }
                    case "[toggle]": {
                        shop = new Toggle(player, target);
                        break;
                    }
                    case "[adeviceon]": {
                        shop = new aDeviceOn(player, target);
                        break;
                    }
                    case "[adeviceoff]": {
                        shop = new aDeviceOff(player, target);
                        break;
                    }
                    case "[atoggle]": {
                        shop = new aToggle(player, target);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (ExceptionInInitializerError e) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, e.getMessage()}));
                return false;
            }
            for (Location<World> loc : shop.getLocations()) {
                Optional<List<Shop>> oldShopList = ShopsData.getShops(loc);
                if (!oldShopList.isPresent()) continue;
                for (Shop oldShop2 : oldShopList.get()) {
                    if (oldShop2.isOwner(player)) continue;
                    player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_OVERRIDE}));
                    return false;
                }
            }
            Optional<List<Shop>> oldShopList = ShopsData.getShops(shop.getLocation());
            if (oldShopList.isPresent()) {
                ArrayList toDelete = new ArrayList();
                oldShopList.get().forEach(oldShop -> toDelete.add(oldShop));
                toDelete.forEach(oldShop -> oldShop.destroy((CommandSource)player));
            }
            ShopsData.addShop(shop);
            return true;
        }
        return false;
    }
}

