/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.api.world;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.block.IBlockState;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.util.Position3f;
import crafttweaker.api.world.IBiome;
import crafttweaker.api.world.IBlockAccess;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IExplosion;
import crafttweaker.api.world.IRayTraceResult;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorldInfo;
import crafttweaker.api.world.IWorldProvider;
import java.util.ArrayList;
import java.util.List;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="crafttweaker.world.IWorld")
@ZenRegister
public interface IWorld
extends IBlockAccess {
    @ZenMethod
    public int getBrightness(IBlockPos var1);

    @ZenMethod
    public int getBrightness(int var1, int var2, int var3);

    @ZenMethod
    public IBiome getBiome(Position3f var1);

    @ZenMethod
    public IBiome getBiome(IBlockPos var1);

    @ZenGetter(value="worldInfo")
    @ZenMethod
    public IWorldInfo getWorldInfo();

    @ZenGetter(value="remote")
    @ZenMethod
    public boolean isRemote();

    @ZenGetter(value="raining")
    @ZenMethod
    public boolean isRaining();

    @ZenGetter(value="dayTime")
    @ZenMethod
    public boolean isDayTime();

    @ZenGetter(value="time")
    @ZenMethod
    public long getWorldTime();

    @ZenGetter(value="surfaceWorld")
    @ZenMethod
    public boolean isSurfaceWorld();

    @ZenGetter(value="moonPhase")
    @ZenMethod
    public int getMoonPhase();

    @ZenGetter(value="dimension")
    @ZenMethod
    public int getDimension();

    @ZenGetter(value="dimensionType")
    @ZenMethod
    public String getDimensionType();

    @ZenMethod
    public IBlock getBlock(int var1, int var2, int var3);

    @ZenMethod
    public IBlock getBlock(IBlockPos var1);

    @ZenGetter(value="worldType")
    @ZenMethod
    public String getWorldType();

    @ZenMethod
    public boolean setBlockState(IBlockState var1, IBlockPos var2);

    @ZenMethod
    public boolean setBlockState(IBlockState var1, IData var2, IBlockPos var3);

    @ZenGetter(value="provider")
    @ZenMethod
    public IWorldProvider getProvider();

    @Override
    public Object getInternal();

    @ZenMethod
    public boolean spawnEntity(IEntity var1);

    @ZenMethod
    default public IRayTraceResult rayTraceBlocks(IVector3d begin, IVector3d ray, @Optional boolean stopOnLiquid, @Optional boolean ignoreBlockWithoutBoundingBox, @Optional(valueBoolean=true) boolean returnLastUncollidableBlock) {
        CraftTweakerAPI.logError(this.getClass().getName() + " does not override IWorld.getRayTrace, tell the author to fix that.");
        return null;
    }

    @ZenMethod
    default public List<IEntity> getEntitiesInArea(Position3f start, @Optional Position3f end) {
        CraftTweakerAPI.logError(this.getClass().getName() + " does not override IWorld.getEntitiesInArea, tell the author to fix that.");
        return new ArrayList<IEntity>();
    }

    @ZenMethod
    default public IItemStack getPickedBlock(IBlockPos pos, IRayTraceResult rayTraceResult, IPlayer player) {
        CraftTweakerAPI.logError(this.getClass().getName() + " does not override IWorld.getPickedBlock, tell the author to fix that.");
        return null;
    }

    @ZenMethod
    default public IExplosion createExplosion(IEntity exploder, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        CraftTweakerAPI.logError(this.getClass().getName() + " does not override IWorld.createExplosion, tell the author to fix that.");
        return null;
    }

    @ZenMethod
    default public IExplosion performExplosion(IEntity exploder, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        CraftTweakerAPI.logError(this.getClass().getName() + " does not override IWorld.performExplosion, tell the author to fix that.");
        return null;
    }

    @ZenMethod
    default public IExplosion performExplosion(IExplosion explosion) {
        CraftTweakerAPI.logError(this.getClass().getName() + " does not override IWorld.performExplosion, tell the author to fix that.");
        return null;
    }
}

