/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common;

import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.common.Dependencies;
import wanion.lib.common.IController;
import wanion.lib.common.WTileEntity;
import wanion.lib.common.control.ControlController;
import wanion.lib.common.control.IControlContainer;
import wanion.lib.common.field.FieldController;
import wanion.lib.common.field.IFieldContainer;
import wanion.lib.common.matching.IMatchingContainer;
import wanion.lib.common.matching.MatchingController;

public abstract class WContainer<T extends WTileEntity>
extends Container
implements IControlContainer,
IFieldContainer,
IMatchingContainer {
    private final Dependencies<IController<?, ?>> controllerHandler = new Dependencies();
    private final Collection<IController<?, ?>> controllers = this.controllerHandler.getInstances();
    private final T wTileEntity;

    public WContainer(@Nonnull T wTileEntity) {
        this.wTileEntity = wTileEntity;
        ((WTileEntity)((Object)wTileEntity)).getControllers().forEach(controller -> this.controllerHandler.add((IController)controller.copy()));
    }

    public final T getTile() {
        return this.wTileEntity;
    }

    public final String getTileName() {
        return ((WTileEntity)((Object)this.wTileEntity)).func_70005_c_();
    }

    public void func_75132_a(@Nonnull IContainerListener listener) {
        super.func_75132_a(listener);
        if (!(listener instanceof EntityPlayerMP)) {
            return;
        }
        this.controllers.forEach(controller -> controller.addListener(this.field_75152_c, this, (EntityPlayerMP)listener));
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.controllers.forEach(controller -> controller.detectAndSendChanges(this.field_75152_c, this));
    }

    public final boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return ((WTileEntity)((Object)this.wTileEntity)).func_70300_a(playerIn);
    }

    @Override
    public final Collection<IContainerListener> getListeners() {
        return this.field_75149_d;
    }

    public void func_75134_a(@Nonnull EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!((WTileEntity)((Object)this.wTileEntity)).hasController(FieldController.class)) {
            return;
        }
        ((WTileEntity)((Object)this.wTileEntity)).getController(FieldController.class).getInstances().forEach(field -> field.endInteraction(playerIn));
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound smartNBT) {
        ((WTileEntity)((Object)this.wTileEntity)).getControllers().forEach(controller -> controller.readNBT(smartNBT));
        this.wTileEntity.func_70296_d();
    }

    @Override
    public void receiveNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        this.getFieldController().receiveNBT(nbtTagCompound);
        this.wTileEntity.func_70296_d();
    }

    @Override
    @Nonnull
    public final ControlController getControlController() {
        return ((WTileEntity)((Object)this.wTileEntity)).getController(ControlController.class);
    }

    @Override
    @Nonnull
    public final ControlController getContainerControlController() {
        return (ControlController)((Object)this.controllerHandler.get(ControlController.class));
    }

    @Override
    @Nonnull
    public final FieldController getFieldController() {
        return ((WTileEntity)((Object)this.wTileEntity)).getController(FieldController.class);
    }

    @Override
    @Nonnull
    public final FieldController getContainerFieldController() {
        return (FieldController)((Object)this.controllerHandler.get(FieldController.class));
    }

    @Override
    @Nonnull
    public final MatchingController getMatchingController() {
        return ((WTileEntity)((Object)this.wTileEntity)).getController(MatchingController.class);
    }

    @Override
    @Nonnull
    public final MatchingController getContainerMatchingController() {
        return (MatchingController)((Object)this.controllerHandler.get(MatchingController.class));
    }
}

