/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.container;

import ic2.core.IC2;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.slots.SlotBase;
import ic2.core.inventory.slots.SlotGhoest;
import ic2.core.inventory.slots.SlotOutput;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.tileentity.TileEntityAutocraftingTable;

public class ContainerAutocraftingTable
extends ContainerTileComponent<TileEntityAutocraftingTable> {
    private InventoryCrafting fakeMatrix = new InventoryCrafting((Container)this, 3, 3);
    TileEntityAutocraftingTable block;
    EntityPlayer player;

    public ContainerAutocraftingTable(InventoryPlayer player, TileEntityAutocraftingTable tile) {
        super((IHasGui)tile);
        this.block = tile;
        this.player = player.field_70458_d;
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                this.func_75146_a((Slot)new SlotBase((IHasInventory)tile, k + l * 3, 8 + k * 18, 5 + l * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a((Slot)new SlotOutput(player.field_70458_d, (IHasInventory)tile, l + 9, 8 + l * 18, 60));
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotGhoest((IHasInventory)tile, 18 + (j + i * 3), 64 + j * 17, 6 + i * 17));
            }
        }
        this.func_75146_a((Slot)new SlotGhoest((IHasInventory)tile, 27, 143, 5));
        this.func_75146_a((Slot)new SlotOutput(player.field_70458_d, (IHasInventory)tile, 28, 143, 41));
        this.addPlayerInventory(player, 0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.disableName();
        gui.dissableInvName();
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (ContainerAutocraftingTable.within(slotId, 18, 26)) {
            ItemStack stack = player.field_71071_by.func_70445_o();
            this.block.inventory.set(slotId, (Object)this.doWeirdStackCraftingStuff(stack, slotId));
            if (IC2.platform.isSimulating()) {
                this.checkForMatchingRecipes();
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack doWeirdStackCraftingStuff(ItemStack stack, int slotId) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack slotStack = this.block.getStackInSlot(slotId);
        if (ContainerAutocraftingTable.isEqual(stack, slotStack) && slotStack.func_190916_E() < slotStack.func_77976_d()) {
            if (GuiScreen.func_146272_n()) {
                return StackUtil.copyWithSize((ItemStack)slotStack, (int)ContainerAutocraftingTable.clip(slotStack.func_190916_E() + stack.func_190916_E(), 1, 64));
            }
            return StackUtil.copyWithSize((ItemStack)slotStack, (int)(slotStack.func_190916_E() + 1));
        }
        return StackUtil.copyWithSize((ItemStack)stack, (int)1);
    }

    public static boolean isEqual(ItemStack stack, ItemStack toCompare) {
        return StackUtil.isStackEqual((ItemStack)stack, (ItemStack)toCompare, (boolean)false, (boolean)false);
    }

    public static int clip(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static boolean within(int value, int low, int high) {
        return value >= low && value <= high;
    }

    public void checkForMatchingRecipes() {
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            ItemStack craftingOutput = recipe.func_77571_b().func_77946_l();
            for (int i = 18; i < 27; ++i) {
                this.fakeMatrix.func_70299_a(i - 18, ((ItemStack)this.block.inventory.get(i)).func_77946_l());
            }
            if (recipe.func_77569_a(this.fakeMatrix, this.block.func_145831_w())) {
                this.block.currentRecipe.clear();
                ArrayList<ItemStack> tempList = new ArrayList<ItemStack>();
                for (int j = 0; j < this.fakeMatrix.func_70302_i_(); ++j) {
                    tempList.add(this.fakeMatrix.func_70301_a(j).func_77946_l());
                }
                this.block.setStackInSlot(27, craftingOutput);
                ContainerAutocraftingTable.mergeItems(this.block.currentRecipe, tempList);
                return;
            }
            this.block.setStackInSlot(27, ItemStack.field_190927_a);
            this.block.currentRecipe.clear();
        }
    }

    public static List<ItemStack> mergeItems(List<ItemStack> a, List<ItemStack> b) {
        int size = b.size();
        for (int i = 0; i < size; ++i) {
            if (b.get(i).func_190926_b()) continue;
            int position = ContainerAutocraftingTable.contains(a, b.get(i));
            if (position == -1) {
                a.add(b.get(i));
                continue;
            }
            a.get(position).func_190917_f(b.get(i).func_190916_E());
        }
        return a;
    }

    public static int contains(List<ItemStack> list, ItemStack item) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!StackUtil.isStackEqual((ItemStack)list.get(i), (ItemStack)item)) continue;
            return i;
        }
        return -1;
    }

    public ResourceLocation getTexture() {
        return ((TileEntityAutocraftingTable)((Object)this.getGuiHolder())).getGuiTexture();
    }

    public boolean func_75145_c(EntityPlayer player) {
        return ((TileEntityAutocraftingTable)((Object)this.getGuiHolder())).canInteractWith(player);
    }

    public int guiInventorySize() {
        return ((TileEntityAutocraftingTable)((Object)this.getGuiHolder())).slotCount;
    }
}

