/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.tile;

import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorInvFilled;
import ic2.core.block.base.util.comparator.comparators.ComparatorInventoryFilled;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.base.IRotatingInventory;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.util.obj.IItemContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class TileEntityMachine
extends TileEntityBlock
implements IItemContainer,
IHasInventory,
IHasHandler,
IRotatingInventory {
    protected InventoryHandler handler = new InventoryHandler(this);
    public NonNullList<ItemStack> inventory;
    public int slotCount;

    public TileEntityMachine(int slots) {
        this.slotCount = slots;
        this.inventory = NonNullList.func_191197_a((int)slots, (Object)ItemStack.field_190927_a);
        this.addSlots(this.handler);
        this.handler.validateSlots();
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorInvFilled(this));
        manager.addComparatorMode(new ComparatorInventoryFilled(this));
    }

    protected void addSlots(InventoryHandler handler) {
    }

    @Override
    public InventoryHandler getHandler() {
        return this.handler;
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.inventory.size());
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        InventoryHandler handler = this.getHandler();
        if (handler != null) {
            IHasInventory inv = handler.getUpgradeSlots();
            for (int i = 0; i < inv.getSlotCount(); ++i) {
                ItemStack result = inv.getStackInSlot(i);
                if (result == null) continue;
                list.add(result);
            }
        }
        return list;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.handler.readFromNBT(nbt.func_74775_l("HandlerNBT"));
        this.inventory = NonNullList.func_191197_a((int)this.slotCount, (Object)ItemStack.field_190927_a);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            byte byte0 = data.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.inventory.size()) continue;
            this.inventory.set((int)byte0, (Object)new ItemStack(data));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.handler.writeToNBT(this.getTag(nbt, "HandlerNBT"));
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(data);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        return nbt;
    }

    @Override
    public boolean canUpdate() {
        return this.isSimulating();
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    @Override
    public int getSlotCount() {
        return this.slotCount;
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 64;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.getHandler() == null) {
                return false;
            }
            return this.handler.hasInventory(facing);
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.getHandler() == null) {
                return null;
            }
            return (T)this.handler.getInventory(facing);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean supportsRotation() {
        return true;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing && facing.func_176740_k().func_176722_c();
    }
}

