/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.api;

import java.util.HashSet;
import java.util.Set;
import landmaster.plustic.PlusTiC;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.net.PacketSetPortal;
import landmaster.plustic.util.Coord4D;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class Portal {
    @CapabilityInject(value=IPortalArmor.class)
    private static Capability<IPortalArmor> PORTAL_ARMOR = null;
    public static final ResourceLocation PORTALARMOR_CAPLOCATION = new ResourceLocation("plustic", "portalarmor_cap");
    public static final String PORTAL_NBT = "nickoftime";
    private static final Set<String> portalable;

    @SubscribeEvent
    public static void addPortalArmorCapability(AttachCapabilitiesEvent<Entity> event) {
        if (Loader.isModLoaded((String)"conarm") && event.getObject() instanceof EntityPlayer) {
            event.addCapability(PORTALARMOR_CAPLOCATION, (ICapabilityProvider)new PortalArmorProvider());
        }
    }

    public static void addPortalable(String identifier) {
        portalable.add(identifier);
    }

    public static boolean canUse(NBTTagCompound nbt) {
        for (String identifier : portalable) {
            if (!TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)identifier)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void copyOnDeath(PlayerEvent.Clone event) {
        IPortalArmor oldCap = (IPortalArmor)event.getOriginal().getCapability(PORTAL_ARMOR, null);
        IPortalArmor newCap = (IPortalArmor)event.getEntityPlayer().getCapability(PORTAL_ARMOR, null);
        if (oldCap != null && newCap != null) {
            newCap.location(oldCap.location());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void testSetPortal(InputEvent.KeyInputEvent event) {
        if (PlusTiC.proxy.isControlPressed("set_portal")) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetPortal());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent event) {
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        if (event.isCanceled() || event.getItemStack() == null || !Portal.canUse(nbt0)) {
            return;
        }
        if (nbt0.func_150297_b(PORTAL_NBT, 10)) {
            NBTTagCompound nbt = nbt0.func_74775_l(PORTAL_NBT);
            event.getToolTip().add(I18n.func_135052_a((String)"tooltip.plustic.portal.info", (Object[])new Object[]{nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), nbt.func_74762_e("dim")}));
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(Portal.class);
        CapabilityManager.INSTANCE.register(IPortalArmor.class, (Capability.IStorage)new Capability.IStorage<IPortalArmor>(){

            public NBTBase writeNBT(Capability<IPortalArmor> capability, IPortalArmor instance, EnumFacing side) {
                return instance.location().toNBT(new NBTTagCompound());
            }

            public void readNBT(Capability<IPortalArmor> capability, IPortalArmor instance, EnumFacing side, NBTBase nbt) {
                instance.location(Coord4D.fromNBT((NBTTagCompound)nbt));
            }
        }, () -> new PortalArmor());
        portalable = new HashSet<String>();
    }

    private static class PortalArmorProvider
    implements ICapabilitySerializable<NBTTagCompound> {
        @CapabilityInject(value=IPortalArmor.class)
        private static Capability<IPortalArmor> PORTAL_ARMOR = null;
        private final PortalArmor cap = new PortalArmor();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == PORTAL_ARMOR;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == PORTAL_ARMOR) {
                return (T)this.cap;
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)PORTAL_ARMOR.writeNBT((Object)this.cap, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            PORTAL_ARMOR.readNBT((Object)this.cap, null, (NBTBase)nbt);
        }
    }

    private static class PortalArmor
    implements IPortalArmor {
        private Coord4D loc = Coord4D.NIHIL;

        private PortalArmor() {
        }

        @Override
        public Coord4D location() {
            return this.loc;
        }

        @Override
        public void location(Coord4D loc) {
            this.loc = loc;
        }
    }

    public static interface IPortalArmor {
        public Coord4D location();

        public void location(Coord4D var1);
    }
}

