/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.RebornCore;
import reborncore.api.tile.IContainerLayout;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.client.gui.slots.SlotFake;
import reborncore.common.util.ItemUtils;

public abstract class RebornContainer
extends Container {
    private static HashMap<String, RebornContainer> containerMap = new HashMap();
    public HashMap<Integer, BaseSlot> slotMap = new HashMap();
    private Optional<TileEntity> baseTile = Optional.empty();

    @Deprecated
    public RebornContainer() {
    }

    public RebornContainer(TileEntity tileEntity) {
        this.baseTile = Optional.of(tileEntity);
    }

    @Nullable
    public static RebornContainer getContainerFromClass(Class<? extends RebornContainer> clazz, TileEntity tileEntity) {
        return RebornContainer.createContainer(clazz, tileEntity, RebornCore.proxy.getPlayer());
    }

    public static RebornContainer createContainer(Class<? extends RebornContainer> clazz, TileEntity tileEntity, EntityPlayer player) {
        if (player == null && containerMap.containsKey(clazz.getCanonicalName())) {
            return containerMap.get(clazz.getCanonicalName());
        }
        try {
            RebornContainer container = null;
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterCount() == 0) {
                    container = clazz.newInstance();
                    if (!(container instanceof IContainerLayout)) continue;
                    ((IContainerLayout)((Object)container)).setTile(tileEntity);
                    ((IContainerLayout)((Object)container)).addInventorySlots();
                    continue;
                }
                if (constructor.getParameterCount() != 2) continue;
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes[0].isInstance(tileEntity) && paramTypes[1] == EntityPlayer.class) {
                    container = clazz.getDeclaredConstructor(tileEntity.getClass(), EntityPlayer.class).newInstance(tileEntity, player);
                    continue;
                }
                if (paramTypes[0] != EntityPlayer.class || !paramTypes[1].isInstance(tileEntity)) continue;
                container = clazz.getDeclaredConstructor(EntityPlayer.class, tileEntity.getClass()).newInstance(player, tileEntity);
            }
            if (container == null) {
                RebornCore.logHelper.error("Failed to create container for " + clazz.getName() + " bad things may happen, please report to devs");
            }
            containerMap.put(clazz.getCanonicalName(), container);
            return container;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    protected Slot func_75146_a(Slot slotIn) {
        Slot slot = super.func_75146_a(slotIn);
        if (slot instanceof BaseSlot) {
            this.slotMap.put(slot.getSlotIndex(), (BaseSlot)slot);
        }
        return slot;
    }

    public ItemStack func_82846_b(EntityPlayer player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.func_75216_d()) {
            ItemStack destinationStack;
            ItemStack sourceItemStack = sourceSlot.func_75211_c();
            int oldSourceItemStackSize = ItemUtils.getSize(sourceItemStack);
            ItemStack itemStack = destinationStack = sourceSlot.field_75224_c == player.field_71071_by ? this.handlePlayerSlotShiftClick(player, sourceItemStack) : this.handleGUISlotShiftClick(player, sourceItemStack);
            if (ItemUtils.isEmpty(destinationStack) || ItemUtils.getSize(destinationStack) != oldSourceItemStackSize) {
                sourceSlot.func_75215_d(destinationStack);
                sourceSlot.func_190901_a(player, sourceItemStack);
                if (!player.func_130014_f_().field_72995_K) {
                    this.func_75142_b();
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public void drawPlayersInv(EntityPlayer player, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new BaseSlot((IInventory)player.field_71071_by, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
    }

    public void drawPlayersHotBar(EntityPlayer player, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new BaseSlot((IInventory)player.field_71071_by, i, x + i * 18, y));
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.baseTile.isPresent()) {
            BlockPos pos;
            World world = player.func_130014_f_();
            return world.func_175625_s(pos = this.baseTile.get().func_174877_v()) == this.baseTile.get() && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
        }
        return true;
    }

    protected ItemStack handlePlayerSlotShiftClick(EntityPlayer player, ItemStack sourceItemStack) {
        block0: for (int pass = 0; pass < 4 && !ItemUtils.isEmpty(sourceItemStack); ++pass) {
            for (Slot targetSlot : this.field_75151_b) {
                if (targetSlot.field_75224_c == player.field_71071_by || !RebornContainer.isValidTargetSlot(targetSlot, sourceItemStack, pass % 2 == 1, pass < 2) || !ItemUtils.isEmpty(sourceItemStack = RebornContainer.transfer(sourceItemStack, targetSlot))) continue;
                continue block0;
            }
        }
        return sourceItemStack;
    }

    protected ItemStack handleGUISlotShiftClick(EntityPlayer player, ItemStack sourceItemStack) {
        block0: for (int pass = 0; pass < 2 && !ItemUtils.isEmpty(sourceItemStack); ++pass) {
            ListIterator it = this.field_75151_b.listIterator(this.field_75151_b.size());
            while (it.hasPrevious()) {
                Slot targetSlot = (Slot)it.previous();
                if (targetSlot.field_75224_c != player.field_71071_by || !RebornContainer.isValidTargetSlot(targetSlot, sourceItemStack, pass == 1, false) || !ItemUtils.isEmpty(sourceItemStack = RebornContainer.transfer(sourceItemStack, targetSlot))) continue;
                continue block0;
            }
        }
        return sourceItemStack;
    }

    protected static boolean isValidTargetSlot(Slot slot, ItemStack itemStack, boolean allowEmpty, boolean requireInputOnly) {
        if (slot instanceof SlotFake) {
            return false;
        }
        if (!slot.func_75214_a(itemStack)) {
            return false;
        }
        if (!allowEmpty && !slot.func_75216_d()) {
            return false;
        }
        return !requireInputOnly || slot.func_75214_a(itemStack);
    }

    protected static ItemStack transfer(ItemStack itemStack, Slot destination) {
        int amount = RebornContainer.getTransferAmount(itemStack, destination);
        if (amount <= 0) {
            return itemStack;
        }
        ItemStack destinationStack = destination.func_75211_c();
        destination.func_75215_d(ItemUtils.isEmpty(destinationStack) ? ItemUtils.copyWithSize(itemStack, amount) : ItemUtils.increaseSize(destinationStack, amount));
        return ItemUtils.decreaseSize(itemStack, amount);
    }

    protected static int getTransferAmount(ItemStack itemStack, Slot destination) {
        int maxAmount = Math.min(destination.field_75224_c.func_70297_j_(), destination.func_75219_a());
        maxAmount = Math.min(maxAmount, itemStack.func_77985_e() ? itemStack.func_77976_d() : 1);
        ItemStack destinationStack = destination.func_75211_c();
        if (!ItemUtils.isEmpty(destinationStack)) {
            if (!ItemUtils.isItemEqual(itemStack, destinationStack, true, true)) {
                return 0;
            }
            maxAmount -= ItemUtils.getSize(destinationStack);
        }
        return Math.min(maxAmount, ItemUtils.getSize(itemStack));
    }
}

