/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.render.hitbox;

public class CustomHitBox {
    public boolean[] drawSide = new boolean[]{false, false, false, false, false, false};
    public double[] sideLength = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    public double middleHeight = 0.0;
    public double middleWidth = 0.0;
    public double middleDepth = 0.0;
    public double minX = 0.0;
    public double minY = 0.0;
    public double minZ = 0.0;

    public CustomHitBox(double middleHeight, double middleWidth, double middleDepth, double minX, double minY, double minZ) {
        this.middleDepth = middleDepth;
        this.middleHeight = middleHeight;
        this.middleWidth = middleWidth;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
    }

    public CustomHitBox drawSide(int side, boolean draw) {
        if (this.drawSide.length > side) {
            this.drawSide[side] = draw;
        }
        return this;
    }

    public CustomHitBox setSideLength(int side, double length) {
        if (this.sideLength.length > side) {
            this.sideLength[side] = length;
        }
        return this;
    }

    public CustomHitBox offsetForDraw(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        return this;
    }

    public CustomHitBox addExtraSpace(double extraSpace) {
        this.minX -= extraSpace;
        this.minY -= extraSpace;
        this.minZ -= extraSpace;
        this.middleDepth += extraSpace;
        this.middleHeight += extraSpace;
        this.middleWidth += extraSpace;
        int i = 0;
        while (i < this.sideLength.length) {
            int n = i++;
            this.sideLength[n] = this.sideLength[n] + extraSpace;
        }
        return this;
    }
}

