/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.commands;

import com.erigitic.config.AccountManager;
import com.erigitic.config.TEAccount;
import com.erigitic.config.TECurrency;
import com.erigitic.main.TotalEconomy;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class BalanceTopCommand
implements CommandExecutor {
    private TotalEconomy totalEconomy;
    private AccountManager accountManager;
    private PaginationService paginationService = (PaginationService)Sponge.getServiceManager().provideUnchecked(PaginationService.class);
    private PaginationList.Builder builder = this.paginationService.builder();

    public BalanceTopCommand(TotalEconomy totalEconomy, AccountManager accountManager) {
        this.totalEconomy = totalEconomy;
        this.accountManager = accountManager;
    }

    public static CommandSpec commandSpec(TotalEconomy totalEconomy) {
        return CommandSpec.builder().description((Text)Text.of((String)"Display top balances")).permission("totaleconomy.command.balancetop").arguments(GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"currency")))).executor((CommandExecutor)new BalanceTopCommand(totalEconomy, totalEconomy.getAccountManager())).build();
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional optCurrency = args.getOne("currency");
        TECurrency currency = null;
        ArrayList<Text> accountBalances = new ArrayList<Text>();
        if (optCurrency.isPresent()) {
            currency = this.totalEconomy.getTECurrencyRegistryModule().getById("totaleconomy:" + ((String)optCurrency.get()).toLowerCase()).orElse(null);
        }
        if (currency == null) {
            currency = this.totalEconomy.getDefaultCurrency();
        }
        TECurrency fCurrency = currency;
        if (this.totalEconomy.isDatabaseEnabled()) {
            try {
                Statement statement = this.totalEconomy.getSqlManager().dataSource.getConnection().createStatement();
                String currencyColumn = currency.getName() + "_balance";
                statement.execute("SELECT * FROM accounts ORDER BY `" + currencyColumn + "` DESC LIMIT 10");
                ResultSet set = statement.getResultSet();
                while (set.next()) {
                    BigDecimal amount = set.getBigDecimal(currencyColumn);
                    UUID uuid = UUID.fromString(set.getString("uid"));
                    Optional optUser = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(uuid);
                    String username = optUser.map(User::getName).orElse("unknown");
                    accountBalances.add(Text.of((Object[])new Object[]{TextColors.GRAY, username, ": ", TextColors.GOLD, currency.format(amount)}));
                }
            }
            catch (SQLException e) {
                throw new CommandException((Text)Text.of((String)"Failed to query db for ranking."), (Throwable)e);
            }
        } else {
            ConfigurationNode accountNode = this.accountManager.getAccountConfig();
            HashMap accountBalancesMap = new HashMap();
            accountNode.getChildrenMap().keySet().forEach(accountUUID -> {
                UUID uuid;
                try {
                    uuid = UUID.fromString(accountUUID.toString());
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                TEAccount playerAccount = (TEAccount)this.accountManager.getOrCreateAccount(uuid).get();
                Text playerName = playerAccount.getDisplayName();
                accountBalancesMap.put(playerName.toPlain(), playerAccount.getBalance(fCurrency));
            });
            accountBalancesMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).forEach(entry -> accountBalances.add(Text.of((Object[])new Object[]{TextColors.GRAY, entry.getKey(), ": ", TextColors.GOLD, fCurrency.format((BigDecimal)entry.getValue()).toPlain()})));
        }
        this.builder.title(Text.of((Object[])new Object[]{TextColors.GOLD, "Top 10 Balances"})).contents(accountBalances).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

