/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.entity.mobs;

import icbm.classic.content.entity.EntityFragments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public abstract class EntityXmasMob
extends EntityMob
implements IRangedAttackMob {
    public EntityXmasMob(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.6f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 0.1, this.getFireDelay(), 50.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected int getFireDelay() {
        return 5;
    }

    public boolean isOnTeam(Entity entity) {
        if (entity instanceof EntityXmasMob) {
            return ((EntityXmasMob)entity).isIceFaction() == this.isIceFaction();
        }
        return false;
    }

    public abstract boolean isIceFaction();

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityFragments fragment = this.getProjectile(target, distanceFactor);
        fragment.shootingEntity = this;
        fragment.isIce = this.isIceFaction();
        fragment.isFire = !this.isIceFaction();
        fragment.isXmasBullet = true;
        fragment.damage = this.getDamageForGun();
        double deltaX = target.field_70165_t - this.field_70165_t;
        double deltaY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - fragment.field_70163_u;
        double deltaZ = target.field_70161_v - this.field_70161_v;
        double distance = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaZ * deltaZ));
        fragment.field_70165_t += this.getProjectileXOffset(target, deltaX, distance);
        fragment.field_70163_u += this.getProjectileYOffset(target, deltaY, distance);
        fragment.field_70161_v += this.getProjectileZOffset(target, deltaZ, distance);
        deltaX = target.field_70165_t - this.field_70165_t;
        deltaY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - fragment.field_70163_u;
        deltaZ = target.field_70161_v - this.field_70161_v;
        float randomAim = this.getProjectileRandom();
        float power = this.getProjectilePower();
        fragment.setArrowHeading(deltaX, deltaY, deltaZ, power, randomAim);
        this.field_70170_p.func_72838_d((Entity)fragment);
    }

    protected float getProjectilePower() {
        return 2.0f;
    }

    protected float getProjectileRandom() {
        return 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4;
    }

    protected int getDamageForGun() {
        return 3;
    }

    protected double getProjectileYOffset(EntityLivingBase target, double deltaY, double distance) {
        return this.func_70047_e();
    }

    protected double getProjectileXOffset(EntityLivingBase target, double delta, double distance) {
        double r = this.getArmRotation();
        double armPos = (Math.cos(r) - Math.sin(r)) * this.getArmOffset();
        r = this.getFacingRotation();
        double forwardOffset = (Math.cos(r) - Math.sin(r)) * this.getForwardOffset();
        return forwardOffset + armPos;
    }

    protected double getProjectileZOffset(EntityLivingBase target, double delta, double distance) {
        double r = this.getArmRotation();
        double armPos = (Math.sin(r) + Math.cos(r)) * this.getArmOffset();
        r = this.getFacingRotation();
        double forwardOffset = (Math.sin(r) + Math.cos(r)) * this.getForwardOffset();
        return forwardOffset + armPos;
    }

    protected double getArmOffset() {
        return -0.35;
    }

    protected double getForwardOffset() {
        return 0.5;
    }

    protected double getFacingRotation() {
        return Math.toRadians(MathHelper.func_76142_g((float)(this.func_70079_am() + 45.0f)));
    }

    protected double getArmRotation() {
        return Math.toRadians(MathHelper.func_76142_g((float)(this.func_70079_am() - 45.0f)));
    }

    protected EntityFragments getProjectile(EntityLivingBase target, float distanceFactor) {
        return new EntityFragments(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false, false);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    protected void debugProjectileSpawns() {
        double x = this.field_70165_t + this.getProjectileXOffset(null, 0.0, 0.0);
        double y = this.field_70163_u + this.getProjectileYOffset(null, 0.0, 0.0);
        double z = this.field_70161_v + this.getProjectileZOffset(null, 0.0, 0.0);
        this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }
}

