/*
 * Decompiled with CFR 0.152.
 */
package thaumicperiphery.items;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;
import thaumicperiphery.crafting.PhantomInkRecipe;
import thaumicperiphery.entities.EntityMagicArrow;
import thaumicperiphery.items.ItemBase;
import thaumicperiphery.render.ModelQuiver;

public class ItemMagicQuiver
extends ItemBase
implements IBauble,
IRenderBauble,
IRechargable {
    public static final int VIS_COST = 1;
    private static ModelQuiver model;

    public ItemMagicQuiver() {
        super("magic_quiver");
        this.func_77625_d(1);
        this.func_77627_a(false);
        this.func_185043_a(new ResourceLocation("thaumicperiphery", "charge"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                if (entity instanceof EntityPlayer) {
                    return RechargeHelper.getChargePercentage((ItemStack)stack, (EntityPlayer)((EntityPlayer)entity));
                }
                return 0.0f;
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public boolean willAutoSync(ItemStack stack, EntityLivingBase entity) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        if (type != IRenderBauble.RenderType.BODY || PhantomInkRecipe.hasPhantomInk(stack)) {
            return;
        }
        IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
        float s = 0.0625f;
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        if (model == null) {
            model = new ModelQuiver(0.03125f);
        }
        float fill = RechargeHelper.getChargePercentage((ItemStack)stack, (EntityPlayer)player);
        model.render(player, fill, 1.0f);
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase player) {
        return 100;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack stack, EntityLivingBase player) {
        return IRechargable.EnumChargeDisplay.NORMAL;
    }

    @SubscribeEvent
    public void onArrowNock(ArrowNockEvent event) {
        if (event.hasAmmo()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack body = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5);
        if (body.func_77973_b() == this && RechargeHelper.getCharge((ItemStack)body) >= 1) {
            player.func_184598_c(event.getHand());
            event.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)event.getBow()));
        }
    }

    @SubscribeEvent
    public void onArrowLoose(ArrowLooseEvent event) {
        if (event.hasAmmo()) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        ItemStack body = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5);
        if (body.func_77973_b() == this && RechargeHelper.getCharge((ItemStack)body) >= 1) {
            event.setCanceled(true);
            ItemStack bow = event.getBow();
            int charge = event.getCharge();
            Object object = bow.func_77973_b() instanceof ItemBow ? bow.func_77973_b() : Items.field_151031_f;
            float vel = ItemBow.func_185059_b((int)charge);
            if ((double)vel >= 0.1 && RechargeHelper.consumeCharge((ItemStack)body, (EntityLivingBase)player, (int)1)) {
                World world = event.getWorld();
                if (!world.field_72995_K) {
                    EntityMagicArrow arrow = new EntityMagicArrow(world, (EntityLivingBase)player);
                    arrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, vel * 3.0f, 1.0f);
                    int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bow);
                    int punch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bow);
                    if (vel == 1.0f) {
                        arrow.func_70243_d(true);
                    }
                    if (power > 0) {
                        arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.3 + 0.5);
                    }
                    if (punch > 0) {
                        arrow.func_70240_a(punch);
                    }
                    bow.func_77972_a(1, (EntityLivingBase)player);
                    world.func_72838_d((Entity)arrow);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + vel * 0.5f);
                player.func_71029_a(StatList.func_188057_b((Item)bow.func_77973_b()));
            }
        }
    }
}

