/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.integration.entity;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import org.dave.ocsensors.integration.AbstractIntegration;
import org.dave.ocsensors.integration.Integrate;
import org.dave.ocsensors.integration.ScanDataList;

@Integrate(name="entity_living")
public class EntityLivingIntegration
extends AbstractIntegration {
    @Override
    public boolean worksWith(Entity entity) {
        return entity instanceof EntityLivingBase;
    }

    @Override
    public void addScanData(ScanDataList data, Entity entity) {
        super.addScanData(data, entity);
        EntityLivingBase living = (EntityLivingBase)entity;
        data.add("name", living.func_70005_c_());
        data.add("health", Float.valueOf(living.func_110143_aJ()));
        data.add("armor", living.func_70658_aO());
        if (!living.func_184607_cu().func_190926_b()) {
            data.add("item", living.func_184607_cu());
        }
        if (living.func_70027_ad()) {
            data.add("burning", true);
        }
        if (living.field_70160_al) {
            data.add("airborne", true);
        }
        ArrayList potionEffects = new ArrayList();
        for (PotionEffect potionEffect : living.func_70651_bq()) {
            HashMap<String, Object> potionData = new HashMap<String, Object>();
            potionData.put("potion", potionEffect.func_188419_a().getRegistryName());
            potionData.put("amplifier", potionEffect.func_76458_c());
            potionData.put("duration", potionEffect.func_76459_b());
            potionEffects.add(potionData);
        }
        if (potionEffects.size() > 0) {
            data.add("effect", potionEffects);
        }
    }
}

