/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.magicavoxel;

import java.util.ArrayList;
import java.util.List;
import lumien.randomthings.handler.magicavoxel.MagicaVoxelRenderModel;
import lumien.randomthings.handler.magicavoxel.Palette;

public class MagicaVoxelModel {
    ArrayList<Voxel> voxels = new ArrayList();
    Palette palette;
    int sizeX;
    int sizeY;
    int sizeZ;
    boolean build;
    MagicaVoxelRenderModel renderModel;
    MagicaVoxelRenderModel randomizedRenderModel;

    public MagicaVoxelModel(Palette palette) {
        this.palette = palette;
        this.build = false;
    }

    public void build() {
        this.randomizedRenderModel = new MagicaVoxelRenderModel(this, true);
        this.randomizedRenderModel.build();
        this.renderModel = new MagicaVoxelRenderModel(this, false);
        this.renderModel.build();
        this.build = true;
    }

    public void addVoxel(int x, int y, int z, int colorIndex) {
        this.voxels.add(new Voxel(x, y, z, colorIndex));
    }

    public void setSize(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public List<Voxel> getVoxels() {
        return this.voxels;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public MagicaVoxelRenderModel getRenderModel(boolean randomized) {
        if (randomized) {
            return this.randomizedRenderModel;
        }
        return this.renderModel;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public void cleanUp() {
        this.renderModel.cleanUp();
        this.randomizedRenderModel.cleanUp();
    }

    public class Voxel {
        int x;
        int y;
        int z;
        int colorIndex;

        public Voxel(int x, int y, int z, int colorIndex) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.colorIndex = colorIndex - 1;
        }
    }
}

