/*
 * Decompiled with CFR 0.152.
 */
package nc.tile;

import java.util.Set;
import nc.network.PacketHandler;
import nc.network.tile.TileUpdatePacket;
import nc.tile.ITile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public interface IGui<PACKET extends TileUpdatePacket>
extends ITile {
    public int getGuiID();

    public Set<EntityPlayer> getPlayersToUpdate();

    public PACKET getGuiUpdatePacket();

    public void onGuiPacket(PACKET var1);

    default public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.getPlayersToUpdate().add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    default public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.getPlayersToUpdate().remove(playerToRemove);
    }

    default public void sendUpdateToListeningPlayers() {
        for (EntityPlayer player : this.getPlayersToUpdate()) {
            PacketHandler.instance.sendTo(this.getGuiUpdatePacket(), (EntityPlayerMP)player);
        }
    }

    default public void sendIndividualUpdate(EntityPlayer player) {
        if (this.getTileWorld().field_72995_K) {
            return;
        }
        PacketHandler.instance.sendTo(this.getGuiUpdatePacket(), (EntityPlayerMP)player);
    }

    default public void sendUpdateToAllPlayers() {
        PacketHandler.instance.sendToAll(this.getGuiUpdatePacket());
    }

    default public int getSideConfigYOffset() {
        return 0;
    }
}

