/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.api;

import io.github.nucleuspowered.nucleus.api.core.NucleusAPIMetaService;
import io.github.nucleuspowered.nucleus.api.core.NucleusPlayerMetadataService;
import io.github.nucleuspowered.nucleus.api.core.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.api.core.NucleusWarmupManagerService;
import io.github.nucleuspowered.nucleus.api.core.NucleusWorldUUIDChangeService;
import io.github.nucleuspowered.nucleus.api.module.afk.NucleusAFKService;
import io.github.nucleuspowered.nucleus.api.module.back.NucleusBackService;
import io.github.nucleuspowered.nucleus.api.module.freezeplayer.NucleusFreezePlayerService;
import io.github.nucleuspowered.nucleus.api.module.home.NucleusHomeService;
import io.github.nucleuspowered.nucleus.api.module.invulnerability.NucleusInvulnerabilityService;
import io.github.nucleuspowered.nucleus.api.module.jail.NucleusJailService;
import io.github.nucleuspowered.nucleus.api.module.kit.NucleusKitService;
import io.github.nucleuspowered.nucleus.api.module.mail.NucleusMailService;
import io.github.nucleuspowered.nucleus.api.module.message.NucleusPrivateMessagingService;
import io.github.nucleuspowered.nucleus.api.module.mute.NucleusMuteService;
import io.github.nucleuspowered.nucleus.api.module.nameban.NucleusNameBanService;
import io.github.nucleuspowered.nucleus.api.module.nickname.NucleusNicknameService;
import io.github.nucleuspowered.nucleus.api.module.note.NucleusNoteService;
import io.github.nucleuspowered.nucleus.api.module.playerinfo.NucleusSeenService;
import io.github.nucleuspowered.nucleus.api.module.rtp.NucleusRTPService;
import io.github.nucleuspowered.nucleus.api.module.staffchat.NucleusStaffChatService;
import io.github.nucleuspowered.nucleus.api.module.warning.NucleusWarningService;
import io.github.nucleuspowered.nucleus.api.module.warp.NucleusWarpService;
import io.github.nucleuspowered.nucleus.api.placeholder.NucleusPlaceholderService;
import io.github.nucleuspowered.nucleus.api.text.NucleusTextTemplateFactory;
import java.util.Optional;
import org.spongepowered.api.Sponge;

public class NucleusAPI {
    private NucleusAPI() {
    }

    public static NucleusAPIMetaService getMetaService() {
        return NucleusAPI.getService(NucleusAPIMetaService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static NucleusPlayerMetadataService getPlayerMetadataService() {
        return NucleusAPI.getService(NucleusPlayerMetadataService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static NucleusWarmupManagerService getWarmupManagerService() {
        return NucleusAPI.getService(NucleusWarmupManagerService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static NucleusPlaceholderService getPlaceholderService() {
        return NucleusAPI.getService(NucleusPlaceholderService.class).orElseThrow(() -> new IllegalStateException("Placeholders are not being registered yet"));
    }

    public static NucleusTextTemplateFactory getTextTemplateFactory() {
        return NucleusAPI.getService(NucleusTextTemplateFactory.class).orElseThrow(() -> new IllegalStateException("Nucleus Text Template Factory has not been registered"));
    }

    public static NucleusWorldUUIDChangeService getWorldUUIDChangeService() {
        return NucleusAPI.getService(NucleusWorldUUIDChangeService.class).orElseThrow(() -> new IllegalStateException("World UUID mappings have not yet been loaded"));
    }

    public static NucleusUserPreferenceService getUserPreferenceService() {
        return NucleusAPI.getService(NucleusUserPreferenceService.class).orElseThrow(() -> new IllegalStateException("Nucleus API has not started registering yet"));
    }

    public static Optional<NucleusAFKService> getAFKService() {
        return NucleusAPI.getService(NucleusAFKService.class);
    }

    public static Optional<NucleusBackService> getBackService() {
        return NucleusAPI.getService(NucleusBackService.class);
    }

    public static Optional<NucleusFreezePlayerService> getFreezePlayerService() {
        return NucleusAPI.getService(NucleusFreezePlayerService.class);
    }

    public static Optional<NucleusHomeService> getHomeService() {
        return NucleusAPI.getService(NucleusHomeService.class);
    }

    public static Optional<NucleusInvulnerabilityService> getInvulnerabilityService() {
        return NucleusAPI.getService(NucleusInvulnerabilityService.class);
    }

    public static Optional<NucleusJailService> getJailService() {
        return NucleusAPI.getService(NucleusJailService.class);
    }

    public static Optional<NucleusKitService> getKitService() {
        return NucleusAPI.getService(NucleusKitService.class);
    }

    public static Optional<NucleusMailService> getMailService() {
        return NucleusAPI.getService(NucleusMailService.class);
    }

    public static Optional<NucleusMuteService> getMuteService() {
        return NucleusAPI.getService(NucleusMuteService.class);
    }

    public static Optional<NucleusNameBanService> getNameBanService() {
        return NucleusAPI.getService(NucleusNameBanService.class);
    }

    public static Optional<NucleusNicknameService> getNicknameService() {
        return NucleusAPI.getService(NucleusNicknameService.class);
    }

    public static Optional<NucleusNoteService> getNoteService() {
        return NucleusAPI.getService(NucleusNoteService.class);
    }

    public static Optional<NucleusPrivateMessagingService> getPrivateMessagingService() {
        return NucleusAPI.getService(NucleusPrivateMessagingService.class);
    }

    public static Optional<NucleusRTPService> getRTPService() {
        return NucleusAPI.getService(NucleusRTPService.class);
    }

    public static Optional<NucleusSeenService> getSeenService() {
        return NucleusAPI.getService(NucleusSeenService.class);
    }

    public static Optional<NucleusStaffChatService> getStaffChatService() {
        return NucleusAPI.getService(NucleusStaffChatService.class);
    }

    public static Optional<NucleusWarningService> getWarningService() {
        return NucleusAPI.getService(NucleusWarningService.class);
    }

    public static Optional<NucleusWarpService> getWarpService() {
        return NucleusAPI.getService(NucleusWarpService.class);
    }

    private static <T> Optional<T> getService(Class<T> clazz) {
        return Sponge.getServiceManager().provide(clazz);
    }
}

