/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate.typeserialisers;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.api.module.warp.data.Warp;
import io.github.nucleuspowered.nucleus.api.util.data.NamedLocation;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.WarpSerialiser;
import io.github.nucleuspowered.nucleus.datatypes.LocationData;
import io.github.nucleuspowered.nucleus.util.TypeTokens;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public class NamedLocationSerialiser
implements TypeSerializer<NamedLocation> {
    private final Logger logger;

    public NamedLocationSerialiser(Logger logger) {
        this.logger = logger;
    }

    public @Nullable NamedLocation deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (type.isSubtypeOf(TypeTokens.WARP)) {
            return new WarpSerialiser(this.logger).deserialize((TypeToken)type, value);
        }
        Vector3d pos = NamedLocationSerialiser.getPosition(value);
        Vector3d rot = NamedLocationSerialiser.getRotation(value);
        return new LocationData(NamedLocationSerialiser.getName(value), NamedLocationSerialiser.getWorldUUID(value), pos, rot);
    }

    public void serialize(@NonNull TypeToken<?> type, @Nullable NamedLocation obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (obj == null) {
            return;
        }
        if (obj instanceof Warp) {
            new WarpSerialiser(this.logger).serialize(type, (Warp)obj, value);
            return;
        }
        NamedLocationSerialiser.serializeLocation(obj, value);
    }

    static String getName(ConfigurationNode value) {
        return value.getNode(new Object[]{"name"}).getString(String.valueOf(value.getKey()));
    }

    static UUID getWorldUUID(ConfigurationNode value) throws ObjectMappingException {
        return (UUID)value.getNode(new Object[]{"world"}).getValue(TypeTokens.UUID);
    }

    static Vector3d getPosition(ConfigurationNode value) {
        return new Vector3d(value.getNode(new Object[]{"x"}).getDouble(), value.getNode(new Object[]{"y"}).getDouble(), value.getNode(new Object[]{"z"}).getDouble());
    }

    static Vector3d getRotation(ConfigurationNode value) {
        return new Vector3d(value.getNode(new Object[]{"rotx"}).getDouble(), value.getNode(new Object[]{"roty"}).getDouble(), value.getNode(new Object[]{"rotz"}).getDouble());
    }

    static void serializeLocation(NamedLocation obj, ConfigurationNode value) throws ObjectMappingException {
        value.getNode(new Object[]{"world"}).setValue(TypeTokens.UUID, (Object)obj.getWorldUUID());
        value.getNode(new Object[]{"x"}).setValue((Object)obj.getPosition().getX());
        value.getNode(new Object[]{"y"}).setValue((Object)obj.getPosition().getY());
        value.getNode(new Object[]{"z"}).setValue((Object)obj.getPosition().getZ());
        value.getNode(new Object[]{"rotx"}).setValue((Object)obj.getRotation().getX());
        value.getNode(new Object[]{"roty"}).setValue((Object)obj.getRotation().getY());
        value.getNode(new Object[]{"rotz"}).setValue((Object)obj.getRotation().getZ());
        value.getNode(new Object[]{"name"}).setValue((Object)obj.getName());
    }
}

