/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.info.services;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.io.TextFileController;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.plugin.PluginContainer;

public class InfoHandler
implements IReloadableService.Reloadable,
ServiceBase {
    private final Map<String, TextFileController> infoFiles = Maps.newHashMap();
    private final Pattern validFile = Pattern.compile("[a-zA-Z0-9_.\\-]+\\.txt", 2);

    public Set<String> getInfoSections() {
        return ImmutableSet.copyOf(this.infoFiles.keySet());
    }

    public Optional<TextFileController> getSection(String name) {
        Optional<String> os = this.infoFiles.keySet().stream().filter(name::equalsIgnoreCase).findFirst();
        return os.map(this.infoFiles::get);
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        List<Path> files;
        Path infoDir = serviceCollection.configDir().resolve("info");
        if (!Files.exists(infoDir, new LinkOption[0])) {
            try {
                Files.createDirectories(infoDir, new FileAttribute[0]);
                AssetManager am = Sponge.getAssetManager();
                PluginContainer pluginContainer = serviceCollection.pluginContainer();
                ((Asset)am.getAsset((Object)pluginContainer, "info.txt").get()).copyToFile(infoDir.resolve("info.txt"));
                ((Asset)am.getAsset((Object)pluginContainer, "colors.txt").get()).copyToFile(infoDir.resolve("colors.txt"));
                ((Asset)am.getAsset((Object)pluginContainer, "links.txt").get()).copyToFile(infoDir.resolve("links.txt"));
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        } else if (!Files.isDirectory(infoDir, new LinkOption[0])) {
            throw new IllegalStateException("The file " + infoDir.toAbsolutePath().toString() + " should be a directory.");
        }
        try (Stream<Path> sp = Files.list(infoDir);){
            files = sp.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x -> this.validFile.matcher(x.getFileName().toString()).matches()).collect(Collectors.toList());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        HashMap mst = Maps.newHashMap();
        files.forEach(x -> {
            try {
                String name = x.getFileName().toString();
                name = name.substring(0, name.length() - 4);
                if (mst.keySet().stream().anyMatch(name::equalsIgnoreCase)) {
                    serviceCollection.logger().warn(serviceCollection.messageProvider().getMessageString("info.load.duplicate", x.getFileName().toString()));
                    return;
                }
                mst.put(name, new TextFileController(serviceCollection.textTemplateFactory(), (Path)x, true));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.infoFiles.clear();
        this.infoFiles.putAll(mst);
    }
}

