/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.services;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.api.module.nickname.NucleusNicknameService;
import io.github.nucleuspowered.nucleus.api.module.nickname.exception.NicknameException;
import io.github.nucleuspowered.nucleus.modules.nickname.NicknameKeys;
import io.github.nucleuspowered.nucleus.modules.nickname.config.NicknameConfig;
import io.github.nucleuspowered.nucleus.modules.nickname.events.ChangeNicknameEventPost;
import io.github.nucleuspowered.nucleus.modules.nickname.events.ChangeNicknameEventPre;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPlayerDisplayNameService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import io.github.nucleuspowered.nucleus.services.interfaces.ITextStyleService;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

@APIService(value=NucleusNicknameService.class)
public class NicknameService
implements NucleusNicknameService,
IReloadableService.Reloadable,
ServiceBase {
    private final IMessageProviderService messageProviderService;
    private final IStorageManager storageManager;
    private final ITextStyleService textStyleService;
    private Text prefix = Text.EMPTY;
    private Pattern pattern;
    private int min = 3;
    private int max = 16;
    private final List<UUID> cached = Lists.newArrayList();
    private final BiMap<UUID, String> cache = HashBiMap.create();
    private final BiMap<UUID, Text> textCache = HashBiMap.create();
    private final TreeMap<String, UUID> reverseLowerCaseCache = new TreeMap();

    @Inject
    public NicknameService(INucleusServiceCollection serviceCollection) {
        this.messageProviderService = serviceCollection.messageProvider();
        this.storageManager = serviceCollection.storageManager();
        this.textStyleService = serviceCollection.textStyleService();
    }

    public void injectResolver(INucleusServiceCollection serviceCollection) {
        serviceCollection.playerDisplayNameService().provideDisplayNameResolver(this::getNicknameWithPrefix);
        serviceCollection.playerDisplayNameService().provideDisplayNameQuery(new IPlayerDisplayNameService.DisplayNameQuery(){

            @Override
            public Optional<User> resolve(String name) {
                return NicknameService.this.getFromCache(name).map(x -> x);
            }

            @Override
            public Map<UUID, String> startsWith(String name) {
                return NicknameService.this.startsWithUUIDStringMap(name);
            }
        });
    }

    public void markRead(UUID player) {
        this.cached.add(player);
    }

    public void updateCache(UUID player, Text text) {
        this.cache.put((Object)player, (Object)text.toPlain());
        this.textCache.put((Object)player, (Object)text);
    }

    public Optional<Player> getFromCache(String text) {
        UUID u = (UUID)this.cache.inverse().get((Object)text);
        if (u != null) {
            Optional ret = Sponge.getServer().getPlayer(u);
            if (!ret.isPresent()) {
                this.cache.remove((Object)u);
            }
            return ret;
        }
        return Optional.empty();
    }

    public Map<String, UUID> getAllCached() {
        return Maps.newHashMap((Map)this.cache.inverse());
    }

    public Map<Player, Text> getFromSubstring(String search) {
        Collection<UUID> uuidCollection;
        String prefix = search.toLowerCase();
        if (prefix.length() > 0) {
            char nextLetter = (char)(prefix.charAt(prefix.length() - 1) + '\u0001');
            String end = prefix.substring(0, prefix.length() - 1) + nextLetter;
            uuidCollection = this.reverseLowerCaseCache.subMap(prefix, end).values();
        } else {
            uuidCollection = this.reverseLowerCaseCache.values();
        }
        ImmutableMap.Builder mapToReturn = ImmutableMap.builder();
        Sponge.getServer().getOnlinePlayers().stream().filter(x -> !this.cache.containsKey((Object)x.getUniqueId())).filter(x -> x.getName().toLowerCase().startsWith(prefix)).forEach(player -> mapToReturn.put(player, (Object)player.get(Keys.DISPLAY_NAME).orElseGet(() -> Text.of((Object[])new Object[]{player.getName(), "*"}))));
        for (UUID uuid : uuidCollection) {
            Optional op = Sponge.getServer().getPlayer(uuid);
            op.ifPresent(player -> mapToReturn.put(player, this.textCache.get((Object)uuid)));
        }
        return mapToReturn.build();
    }

    public Map<String, UUID> startsWithGetMap(String text) {
        return this.cache.inverse().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(text.toLowerCase())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<UUID, String> startsWithUUIDStringMap(String text) {
        return this.cache.inverse().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(text.toLowerCase())).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public List<UUID> startsWith(String text) {
        return this.cache.inverse().entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(text.toLowerCase())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void removeFromCache(UUID player) {
        this.cache.remove((Object)player);
        this.textCache.remove((Object)player);
        this.cached.remove(player);
    }

    @Override
    public Optional<Text> getNicknameWithPrefix(UUID user) {
        return this.getNickname(user).map(x -> Text.join((Text[])new Text[]{this.prefix, x}));
    }

    @Override
    public Optional<Text> getNicknameWithPrefix(User user) {
        return this.getNickname(user).map(x -> Text.join((Text[])new Text[]{this.prefix, x}));
    }

    @Override
    public Optional<Text> getNickname(User user) {
        return this.getNickname(user.getUniqueId());
    }

    @Override
    public Optional<Text> getNickname(UUID user) {
        if (this.cached.contains(user)) {
            return Optional.ofNullable(this.textCache.get((Object)user));
        }
        return this.storageManager.getUserService().getOnThread(user).flatMap(x -> x.get(NicknameKeys.USER_NICKNAME_JSON)).map(arg_0 -> ((TextSerializer)TextSerializers.JSON).deserialize(arg_0));
    }

    @Override
    public void setNickname(User user, @Nullable Text nickname, boolean bypassRestrictions) throws NicknameException {
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        if (nickname != null) {
            this.setNick(user, cause, nickname, bypassRestrictions);
        } else {
            this.removeNick(user, cause);
        }
    }

    public void removeNick(User user, CommandSource src) throws NicknameException {
        this.removeNick(user, CauseStackHelper.createCause(src));
    }

    private void removeNick(User user, Cause cause) throws NicknameException {
        Text currentNickname = this.getNickname(user).orElse(null);
        if (!(user instanceof Player) && user.getPlayer().isPresent()) {
            user = (User)user.getPlayer().get();
        }
        ChangeNicknameEventPre cne = new ChangeNicknameEventPre(cause, currentNickname, null, user);
        if (Sponge.getEventManager().post((Event)cne)) {
            throw new NicknameException(this.messageProviderService.getMessage("command.nick.eventcancel", user.getName()), NicknameException.Type.EVENT_CANCELLED);
        }
        this.storageManager.getUserService().removeAndSave(user.getUniqueId(), NicknameKeys.USER_NICKNAME_JSON);
        this.removeFromCache(user.getUniqueId());
        Sponge.getEventManager().post((Event)new ChangeNicknameEventPost(cause, currentNickname, null, user));
        if (user.isOnline()) {
            user.getPlayer().ifPresent(x -> this.messageProviderService.sendMessageTo((CommandSource)x, "command.delnick.success.base"));
        }
    }

    public void setNick(User pl, CommandSource src, Text nickname, boolean bypass) throws NicknameException {
        this.setNick(pl, CauseStackHelper.createCause(src), nickname, bypass);
    }

    private void setNick(User pl, Cause cause, Text nickname, boolean bypass) throws NicknameException {
        String plain = nickname.toPlain().trim();
        if (plain.isEmpty()) {
            throw new NicknameException(this.messageProviderService.getMessage("command.nick.tooshort"), NicknameException.Type.TOO_SHORT);
        }
        try {
            Optional match = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).get(nickname.toPlain().trim());
            if (match.isPresent() && !((User)match.get()).getUniqueId().equals(pl.getUniqueId())) {
                throw new NicknameException(this.messageProviderService.getMessage("command.nick.nameinuse", plain), NicknameException.Type.NOT_OWN_IGN);
            }
        }
        catch (IllegalArgumentException match) {
            // empty catch block
        }
        if (!(pl instanceof Player) && pl.getPlayer().isPresent()) {
            pl = (User)pl.getPlayer().get();
        }
        if (!bypass) {
            Optional os = cause.first(Subject.class);
            if (os.isPresent()) {
                this.stripPermissionless((Subject)os.get(), nickname);
            }
            if (!this.pattern.matcher(plain).matches()) {
                throw new NicknameException(this.messageProviderService.getMessage("command.nick.nopattern", this.pattern.pattern()), NicknameException.Type.INVALID_PATTERN);
            }
            int strippedNameLength = plain.length();
            if (strippedNameLength < Math.max(this.min, 1)) {
                throw new NicknameException(this.messageProviderService.getMessage("command.nick.tooshort"), NicknameException.Type.TOO_SHORT);
            }
            if (strippedNameLength > Math.max(this.max, this.min)) {
                throw new NicknameException(this.messageProviderService.getMessage("command.nick.toolong"), NicknameException.Type.TOO_SHORT);
            }
        }
        Text currentNickname = this.getNickname(pl).orElse(null);
        ChangeNicknameEventPre cne = new ChangeNicknameEventPre(cause, currentNickname, nickname, pl);
        if (Sponge.getEventManager().post((Event)cne)) {
            throw new NicknameException(this.messageProviderService.getMessage("command.nick.eventcancel", pl.getName()), NicknameException.Type.EVENT_CANCELLED);
        }
        this.storageManager.getUserService().setAndSave(pl.getUniqueId(), NicknameKeys.USER_NICKNAME_JSON, TextSerializers.JSON.serialize(nickname));
        this.updateCache(pl.getUniqueId(), nickname);
        Sponge.getEventManager().post((Event)new ChangeNicknameEventPost(cause, currentNickname, nickname, pl));
        pl.getPlayer().ifPresent(player -> player.sendMessage(Text.builder().append(new Text[]{this.messageProviderService.getMessage("command.nick.success.base")}).append(new Text[]{Text.of((Object[])new Object[]{" - ", TextColors.RESET, nickname})}).build()));
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        NicknameConfig nc = serviceCollection.moduleDataProvider().getModuleConfig(NicknameConfig.class);
        this.pattern = nc.getPattern();
        this.min = nc.getMinNicknameLength();
        this.max = nc.getMaxNicknameLength();
        this.prefix = TextSerializers.FORMATTING_CODE.deserialize(nc.getPrefix());
    }

    private void stripPermissionless(Subject source, Text message) throws NicknameException {
        Collection<String> strings = this.textStyleService.wouldStrip((Collection<String>)ImmutableList.of((Object)"nucleus.nick.colour", (Object)"nucleus.nick.color"), "nucleus.nick.style", source, TextSerializers.FORMATTING_CODE.serialize(message));
        if (!strings.isEmpty()) {
            throw new NicknameException(this.messageProviderService.getMessage("command.nick.nopermscolourstyle", String.join((CharSequence)", ", strings)), NicknameException.Type.INVALID_STYLE_OR_COLOUR);
        }
    }

    public Text getNickPrefix() {
        return this.prefix;
    }
}

