/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.spawn.listeners;

import com.flowpowered.math.vector.Vector3d;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.EventContexts;
import io.github.nucleuspowered.nucleus.api.module.spawn.event.NucleusSendToSpawnEvent;
import io.github.nucleuspowered.nucleus.api.teleport.data.NucleusTeleportHelperFilters;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportScanners;
import io.github.nucleuspowered.nucleus.configurate.datatypes.LocationNode;
import io.github.nucleuspowered.nucleus.modules.core.CoreKeys;
import io.github.nucleuspowered.nucleus.modules.core.config.CoreConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.SpawnKeys;
import io.github.nucleuspowered.nucleus.modules.spawn.config.GlobalSpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.config.SpawnConfig;
import io.github.nucleuspowered.nucleus.modules.spawn.events.SendToSpawnEvent;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IGeneralDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IWorldDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.living.humanoid.player.RespawnPlayerEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

public class SpawnListener
implements IReloadableService.Reloadable,
ListenerBase {
    private SpawnConfig spawnConfig;
    private boolean checkSponge;
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public SpawnListener(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
    }

    @Listener
    public void onJoin(ClientConnectionEvent.Login loginEvent) {
        UUID pl = loginEvent.getProfile().getUniqueId();
        IStorageManager storageManager = this.serviceCollection.storageManager();
        IMessageProviderService messageProviderService = this.serviceCollection.messageProvider();
        boolean first = storageManager.getOrCreateUserOnThread(pl).get(CoreKeys.FIRST_JOIN_PROCESSED).orElse(false) == false ? !this.checkSponge || !Util.hasPlayedBeforeSponge(loginEvent.getTargetUser()) : false;
        IGeneralDataObject generalDataObject = (IGeneralDataObject)storageManager.getGeneralService().getOrNew().join();
        try {
            Optional ofs;
            if (first && (ofs = generalDataObject.get(SpawnKeys.FIRST_SPAWN_LOCATION).flatMap(LocationNode::getTransformIfExists)).isPresent()) {
                Location location = this.spawnConfig.isSafeTeleport() ? (Location)Sponge.getTeleportHelper().getSafeLocation(((Transform)ofs.get()).getLocation()).orElse(null) : ((Transform)ofs.get()).getLocation();
                if (location != null) {
                    loginEvent.setToTransform(new Transform(location.getExtent(), SpawnListener.process(location.getPosition()), ((Transform)ofs.get()).getRotation()));
                    return;
                }
                this.serviceCollection.logger().warn(messageProviderService.getMessageString("spawn.firstspawn.failed", loginEvent.getProfile().getName().orElseGet(() -> messageProviderService.getMessageString("standard.unknown", new Object[0]))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        User user = ((UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class)).getOrCreate(loginEvent.getProfile());
        if (this.spawnConfig.isSpawnOnLogin() && !this.serviceCollection.permissionService().hasPermission((Subject)user, "nucleus.spawn.exempt.login")) {
            World world = (World)loginEvent.getFromTransform().getExtent();
            String worldName = world.getName();
            String uuid = world.getUniqueId().toString();
            if (this.spawnConfig.getOnLoginExemptWorlds().stream().anyMatch(x -> x.equalsIgnoreCase(worldName) || x.equalsIgnoreCase(uuid))) {
                return;
            }
            GlobalSpawnConfig sc = this.spawnConfig.getGlobalSpawn();
            if (sc.isOnLogin() && sc.getWorld().isPresent()) {
                world = Sponge.getServer().getWorld(sc.getWorld().get().getUniqueId()).orElse(world);
            }
            Location lw = world.getSpawnLocation().add(0.5, 0.0, 0.5);
            Optional<Location<World>> safe = this.serviceCollection.teleportService().getSafeLocation((Location<World>)lw, TeleportScanners.ASCENDING_SCAN.get(), this.spawnConfig.isSafeTeleport() ? TeleportHelperFilters.DEFAULT : NucleusTeleportHelperFilters.NO_CHECK.get(), new TeleportHelperFilter[0]);
            if (safe.isPresent()) {
                try {
                    Optional<Vector3d> ov = ((IWorldDataObject)storageManager.getWorldService().getOrNewOnThread(world.getUniqueId())).get(SpawnKeys.WORLD_SPAWN_ROTATION);
                    if (ov.isPresent()) {
                        loginEvent.setToTransform(new Transform(safe.get().getExtent(), SpawnListener.process(safe.get().getPosition()), ov.get()));
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                loginEvent.setToTransform(new Transform(SpawnListener.process(safe.get())));
            }
        }
    }

    @Listener(order=Order.EARLY)
    public void onPlayerWorldTransfer(MoveEntityEvent.Teleport event) {
        Transform to;
        if (event.getTargetEntity() instanceof Player && !((World)event.getFromTransform().getExtent()).equals(event.getToTransform().getExtent()) && (to = event.getToTransform()).getLocation().getBlockPosition().equals((Object)((World)to.getExtent()).getSpawnLocation().getBlockPosition())) {
            ((IWorldDataObject)this.serviceCollection.storageManager().getWorldService().getOrNewOnThread(((World)to.getExtent()).getUniqueId())).get(SpawnKeys.WORLD_SPAWN_ROTATION).ifPresent(y -> event.setToTransform(to.setRotation(y)));
        }
    }

    @Listener(order=Order.EARLY)
    public void onRespawn(RespawnPlayerEvent event, @Getter(value="getTargetEntity") Player player) {
        SendToSpawnEvent sEvent;
        Optional<WorldProperties> oworld;
        if (event.isBedSpawn() && !this.spawnConfig.isRedirectBedSpawn()) {
            return;
        }
        GlobalSpawnConfig sc = this.spawnConfig.getGlobalSpawn();
        World world = (World)event.getToTransform().getExtent();
        if (sc.isOnRespawn() && (oworld = sc.getWorld()).isPresent()) {
            world = Sponge.getServer().getWorld(oworld.get().getUniqueId()).orElse(world);
        }
        Location spawn = world.getSpawnLocation().add(0.5, 0.0, 0.5);
        Transform to = new Transform(spawn);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContexts.SPAWN_EVENT_TYPE, (Object)NucleusSendToSpawnEvent.Type.DEATH);
            frame.pushCause((Object)player);
            sEvent = new SendToSpawnEvent((Transform<World>)to, (User)player, frame.getCurrentCause());
        }
        if (Sponge.getEventManager().post((Event)sEvent)) {
            if (sEvent.getCancelReason().isPresent()) {
                this.serviceCollection.messageProvider().sendMessageTo((CommandSource)player, "command.spawnother.self.failed.reason", sEvent.getCancelReason().get());
                return;
            }
            this.serviceCollection.messageProvider().sendMessageTo((CommandSource)player, "command.spawnother.self.failed.noreason");
            return;
        }
        ((IWorldDataObject)this.serviceCollection.storageManager().getWorldService().getOrNewOnThread(world.getUniqueId())).get(SpawnKeys.WORLD_SPAWN_ROTATION).ifPresent(y -> event.setToTransform(sEvent.isRedirected() ? sEvent.getTransformTo() : to.setRotation(y)));
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.spawnConfig = serviceCollection.moduleDataProvider().getModuleConfig(SpawnConfig.class);
        this.checkSponge = serviceCollection.moduleDataProvider().getModuleConfig(CoreConfig.class).isCheckFirstDatePlayed();
    }

    private static Location<World> process(Location<World> v3d) {
        return new Location(v3d.getExtent(), SpawnListener.process(v3d.getPosition()));
    }

    private static Vector3d process(Vector3d v3d) {
        return v3d.floor().add(0.5, 0.0, 0.5);
    }
}

