/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.staffchat;

import com.google.common.base.Preconditions;
import io.github.nucleuspowered.nucleus.api.module.staffchat.NucleusStaffChatChannel;
import io.github.nucleuspowered.nucleus.modules.staffchat.config.StaffChatConfig;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.chatmessageformatter.AbstractNucleusChatChannel;
import io.github.nucleuspowered.nucleus.services.impl.texttemplatefactory.NucleusTextTemplateImpl;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.serializer.TextSerializers;

public class StaffChatMessageChannel
implements IChatMessageFormatterService.Channel.External<APIChannel>,
IReloadableService.Reloadable {
    private static StaffChatMessageChannel INSTANCE = null;
    private boolean formatting = false;
    private final IPermissionService permissionService;
    private final IUserPreferenceService userPreferenceService;
    private NucleusTextTemplateImpl template;
    private TextColor colour;

    public static StaffChatMessageChannel getInstance() {
        Preconditions.checkState((INSTANCE != null ? 1 : 0) != 0, (Object)"StaffChatMessageChannel#Instance");
        return INSTANCE;
    }

    @Inject
    StaffChatMessageChannel(INucleusServiceCollection serviceCollection) {
        serviceCollection.reloadableService().registerReloadable(this);
        this.permissionService = serviceCollection.permissionService();
        this.userPreferenceService = serviceCollection.userPreferenceService();
        this.onReload(serviceCollection);
        INSTANCE = this;
    }

    @Override
    public boolean willFormat() {
        return true;
    }

    @Override
    public APIChannel createChannel(MessageChannel delegated) {
        MutableMessageChannel mutableMessageChannel = delegated.asMutable();
        mutableMessageChannel.clearMembers();
        this.receivers().stream().filter(x -> delegated.getMembers().contains(x)).forEach(arg_0 -> ((MutableMessageChannel)mutableMessageChannel).addMember(arg_0));
        return new APIChannel((MessageChannel)mutableMessageChannel, mutableMessageChannel.getMembers());
    }

    public boolean formatMessages() {
        return this.formatting;
    }

    public void sendMessageFrom(CommandSource source, Text text) {
        MessageEvent.MessageFormatter formatters = new MessageEvent.MessageFormatter();
        formatters.setBody((TextRepresentable)text);
        this.formatMessageEvent(source, formatters);
        MessageChannel.fixed(this.receivers()).send((Object)source, formatters.format(), ChatTypes.CHAT);
    }

    @Override
    public void formatMessageEvent(CommandSource source, MessageEvent.MessageFormatter formatters) {
        Text prefix = this.template.getForCommandSource(source);
        if (TextSerializers.PLAIN.serialize(formatters.getHeader().toText()).contains("<" + source.getName() + ">")) {
            Text p = formatters.getHeader().toText().replace("<" + source.getName() + ">", Text.of(), true);
            if (p.toPlain().trim().isEmpty()) {
                formatters.setHeader((TextRepresentable)prefix);
            } else {
                formatters.setHeader((TextRepresentable)Text.of((Object[])new Object[]{p, prefix}));
            }
        } else {
            formatters.setHeader((TextRepresentable)Text.of((Object[])new Object[]{formatters.getHeader(), prefix}));
        }
        formatters.setBody((TextRepresentable)Text.of((Object[])new Object[]{this.colour, formatters.getBody()}));
    }

    @Override
    public Collection<MessageReceiver> receivers() {
        List<MessageReceiver> c = Sponge.getServer().getOnlinePlayers().stream().filter(this::test).collect(Collectors.toList());
        c.add((MessageReceiver)Sponge.getServer().getConsole());
        return c;
    }

    @Override
    public boolean ignoreIgnoreList() {
        return true;
    }

    private boolean test(Player player) {
        if (this.permissionService.hasPermission((Subject)player, "nucleus.staffchat.base")) {
            return this.userPreferenceService.getPreferenceFor((User)player, NucleusKeysProvider.VIEW_STAFF_CHAT).orElse(true);
        }
        return false;
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        StaffChatConfig sc = serviceCollection.moduleDataProvider().getModuleConfig(StaffChatConfig.class);
        this.formatting = sc.isIncludeStandardChatFormatting();
        this.template = sc.getMessageTemplate();
        this.colour = serviceCollection.textStyleService().getColourFromString(sc.getMessageColour());
    }

    public static class APIChannel
    extends AbstractNucleusChatChannel.Mutable<APIChannel>
    implements NucleusStaffChatChannel {
        public APIChannel(MessageChannel messageChannel, Collection<MessageReceiver> messageReceivers) {
            super(messageChannel, messageReceivers);
        }
    }
}

