/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.github.nucleuspowered.nucleus.annotationprocessor.Store;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.CatalogRegistryModule;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Store(value="registry")
public abstract class NucleusRegistryModule<T extends CatalogType>
implements AdditionalCatalogRegistryModule<T> {
    private boolean registered = false;
    private final Map<String, T> entries = new HashMap<String, T>();

    public abstract Class<T> catalogClass();

    public abstract void registerModuleDefaults();

    public final void registerDefaults() {
        if (!this.registered) {
            this.registerModuleDefaults();
            this.registered = true;
            Sponge.getRegistry().registerModule(this.catalogClass(), (CatalogRegistryModule)this);
        }
    }

    protected boolean allowsAdditional() {
        return true;
    }

    public void registerAdditionalCatalog(T entry) {
        Preconditions.checkNotNull(entry, (Object)"entry");
        if (this.entries.containsKey(entry.getId().toLowerCase(Locale.ENGLISH))) {
            throw new IllegalArgumentException("Cannot register that ID as it already has been registered");
        }
        if (this.registered && entry.getId().toLowerCase(Locale.ENGLISH).startsWith("nucleus:")) {
            throw new IllegalArgumentException("Cannot register that ID, additional catalogs must not start with the nucleus namespace");
        }
        if (this.registered && !this.allowsAdditional()) {
            throw new IllegalArgumentException("Cannot register additional types for this catalog");
        }
        this.entries.put(entry.getId().toLowerCase(Locale.ENGLISH), entry);
    }

    public Optional<T> getById(String id) {
        String lowerId = id.toLowerCase(Locale.ENGLISH);
        CatalogType instance = (CatalogType)this.entries.get(lowerId);
        if (instance == null && !lowerId.contains(":")) {
            instance = (CatalogType)this.entries.get("nucleus:" + lowerId);
        }
        return Optional.ofNullable(instance);
    }

    public Collection<T> getAll() {
        return ImmutableList.copyOf(this.entries.values());
    }
}

