/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.dataversioning;

import com.google.inject.Singleton;
import io.github.nucleuspowered.nucleus.modules.core.CoreKeys;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IGeneralDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IWorldDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IDataVersioning;

@Singleton
public final class DataVersioning
implements IDataVersioning {
    private final int userDataVersion = 2;
    private final int worldDataVersion = 1;
    private final int generalDataVersion = 1;

    @Override
    public void setVersion(IUserDataObject userDataObject) {
        userDataObject.set(CoreKeys.USER_VERSION, this.userDataVersion);
    }

    @Override
    public void setVersion(IWorldDataObject worldDataObject) {
        this.getClass();
        worldDataObject.set(CoreKeys.WORLD_VERSION, 1);
    }

    @Override
    public void setVersion(IGeneralDataObject generalDataObject) {
        this.getClass();
        generalDataObject.set(CoreKeys.GENERAL_VERSION, 1);
    }

    @Override
    public void migrate(IUserDataObject userDataObject) {
        int currentVersion = userDataObject.get(CoreKeys.USER_VERSION).orElse(1);
        if (currentVersion < this.userDataVersion) {
            if (currentVersion <= 1) {
                userDataObject.set(CoreKeys.FIRST_JOIN_PROCESSED, true);
            }
            userDataObject.set(CoreKeys.USER_VERSION, this.userDataVersion);
        }
    }

    @Override
    public void migrate(IWorldDataObject worldDataObject) {
        int currentVersion = worldDataObject.get(CoreKeys.WORLD_VERSION).orElse(0);
        if (currentVersion == 0) {
            this.getClass();
            worldDataObject.set(CoreKeys.WORLD_VERSION, 1);
        }
    }

    @Override
    public void migrate(IGeneralDataObject generalDataObject) {
        int currentVersion = generalDataObject.get(CoreKeys.GENERAL_VERSION).orElse(0);
        if (currentVersion == 0) {
            this.getClass();
            generalDataObject.set(CoreKeys.GENERAL_VERSION, 1);
        }
    }
}

