/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.userprefs;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github.nucleuspowered.nucleus.api.core.NucleusUserPreferenceService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.PreferenceKeyImpl;
import io.github.nucleuspowered.nucleus.services.interfaces.IUserPreferenceService;
import io.github.nucleuspowered.nucleus.util.LazyLoadFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;

@Singleton
public class UserPreferenceService
implements IUserPreferenceService {
    private final NucleusKeysProvider provider;
    private final Map<String, NucleusUserPreferenceService.PreferenceKey<?>> registered = new HashMap();
    private final Element element;
    public static final Text PREFERENCE_ARG = Text.of((String)"preference");
    public static final Text VALUE_ARG = Text.of((String)"value");
    private final INucleusServiceCollection serviceCollection;

    @Inject
    public UserPreferenceService(INucleusServiceCollection serviceCollection) {
        this.serviceCollection = serviceCollection;
        this.element = new Element(serviceCollection);
        this.provider = new NucleusKeysProvider(serviceCollection);
    }

    @Override
    public void postInit() {
        this.provider.getAll().forEach(x -> this.register((PreferenceKeyImpl)x));
    }

    @Override
    public CommandElement getElement() {
        return this.element;
    }

    @Override
    public void register(PreferenceKeyImpl<?> key) {
        if (this.registered.containsKey(key.getID())) {
            throw new IllegalArgumentException("ID already registered");
        }
        this.registered.put(key.getID(), key);
        this.element.keys.put(key.getID().toLowerCase().replaceAll("^nucleus:", ""), key);
        this.element.keys.put(key.getID().toLowerCase(), key);
    }

    @Override
    public <T> void set(UUID uuid, NucleusUserPreferenceService.PreferenceKey<T> key, @Nullable T value) {
        if (!(Objects.requireNonNull(key) instanceof PreferenceKeyImpl)) {
            throw new IllegalArgumentException("Cannot have custom preference keys");
        }
        PreferenceKeyImpl pki = (PreferenceKeyImpl)key;
        this.set(uuid, pki, value);
        ((PreferenceKeyImpl)key).onSet(this.serviceCollection, uuid, value);
    }

    @Override
    public <T> void set(UUID uuid, PreferenceKeyImpl<T> key, @Nullable T value) {
        this.serviceCollection.storageManager().getUserService().getOrNew(uuid).thenAccept(x -> x.set(key, value));
    }

    @Override
    public Map<NucleusUserPreferenceService.PreferenceKey<?>, Object> get(User user) {
        HashMap ret = new HashMap();
        for (NucleusUserPreferenceService.PreferenceKey<?> key : this.registered.values()) {
            if (!((PreferenceKeyImpl)key).canAccess(this.serviceCollection, user)) continue;
            ret.put(key, this.get(user.getUniqueId(), key).orElse(null));
        }
        return ret;
    }

    @Override
    public <T> Optional<T> get(UUID uuid, NucleusUserPreferenceService.PreferenceKey<T> key) {
        if (!this.registered.containsValue(key)) {
            throw new IllegalArgumentException("Key is not registered.");
        }
        if (!(key instanceof PreferenceKeyImpl)) {
            throw new IllegalArgumentException("Custom preference keys are not supported.");
        }
        PreferenceKeyImpl prefKey = (PreferenceKeyImpl)key;
        Optional<Object> ot = Optional.empty();
        try {
            ot = this.serviceCollection.storageManager().getUserService().getOnThread(uuid).map(x -> x.getOrDefault(prefKey));
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return ot;
    }

    @Override
    public <T> T getUnwrapped(UUID uuid, NucleusUserPreferenceService.PreferenceKey<T> key) {
        return this.get(uuid, key).orElse(null);
    }

    @Override
    public NucleusKeysProvider keys() {
        return this.provider;
    }

    @Override
    public <T> Optional<T> getPreferenceFor(User user, NucleusUserPreferenceService.PreferenceKey<T> key) {
        return this.get(user.getUniqueId(), key);
    }

    @Override
    public <T> void setPreferenceFor(User user, NucleusUserPreferenceService.PreferenceKey<T> key, T value) {
        this.set(user.getUniqueId(), key, value);
    }

    @Override
    public void removePreferenceFor(User user, NucleusUserPreferenceService.PreferenceKey<?> key) {
        this.set(user.getUniqueId(), key, null);
    }

    @Override
    public boolean canAccess(User user, NucleusUserPreferenceService.PreferenceKey<?> key) {
        return ((PreferenceKeyImpl)key).canAccess(this.serviceCollection, user);
    }

    @Override
    public String getDescription(NucleusUserPreferenceService.PreferenceKey<?> key) {
        return ((PreferenceKeyImpl)key).getDescription(this.serviceCollection.messageProvider());
    }

    Map<String, NucleusUserPreferenceService.PreferenceKey<?>> getRegistered() {
        return this.registered;
    }

    public static class Element
    extends CommandElement {
        private final INucleusServiceCollection serviceCollection;
        private final Map<String, NucleusUserPreferenceService.PreferenceKey<?>> keys = new HashMap();

        Element(INucleusServiceCollection serviceCollection) {
            super(null);
            this.serviceCollection = serviceCollection;
        }

        @Nullable
        public Text getKey() {
            return Text.of((String)"<preference> [value]");
        }

        public void parse(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            String next = args.next().toLowerCase();
            Type type = this.parseFirst(source, args, context, next);
            if (args.hasNext()) {
                type.element.apply(this.serviceCollection).parse(source, args, context);
            }
        }

        private Type parseFirst(CommandSource source, CommandArgs args, CommandContext context, String next) throws ArgumentParseException {
            NucleusUserPreferenceService.PreferenceKey<?> key = this.keys.get(next);
            if (key != null) {
                Type type = null;
                Class<?> cls = key.getValueClass();
                if (cls == Boolean.TYPE || cls == Boolean.class) {
                    type = Type.BOOLEAN;
                } else if (cls == Integer.TYPE || cls == Integer.class) {
                    type = Type.INTEGER;
                } else if (cls == Double.TYPE || cls == Double.class) {
                    type = Type.DOUBLE;
                } else if (cls == String.class) {
                    type = Type.STRING;
                } else if (cls == Locale.class) {
                    type = Type.LOCALE;
                }
                if (type != null) {
                    this.checkAccess(key, this.getUser(source, args, context), args, source);
                    context.putArg(PREFERENCE_ARG, key);
                    return type;
                }
            }
            throw args.createError(this.serviceCollection.messageProvider().getMessageFor(source, "args.userprefs.incorrect", next));
        }

        private void checkAccess(NucleusUserPreferenceService.PreferenceKey<?> key, User user, CommandArgs args, CommandSource source) throws ArgumentParseException {
            if (!((PreferenceKeyImpl)key).canAccess(this.serviceCollection, user)) {
                if (source instanceof Player && ((Player)source).getUniqueId().equals(user.getUniqueId())) {
                    throw args.createError(this.serviceCollection.messageProvider().getMessageFor(source, "args.userprefs.noperm.self", key.getID()));
                }
                throw args.createError(this.serviceCollection.messageProvider().getMessageFor(source, "args.userprefs.noperm.other", user.getName(), key.getID()));
            }
        }

        private User getUser(CommandSource source, CommandArgs args, CommandContext context) throws ArgumentParseException {
            Optional o = context.getOne("user");
            if (!o.isPresent()) {
                if (source instanceof User) {
                    return (User)source;
                }
                throw args.createError(this.serviceCollection.messageProvider().getMessageFor(source, "args.user.none"));
            }
            return (User)o.get();
        }

        @Nullable
        protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
            return null;
        }

        public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
            try {
                User user = this.getUser(src, args, context);
                CommandArgs.Snapshot snapshot = args.getSnapshot();
                String arg1 = args.next().toLowerCase();
                if (!args.hasNext()) {
                    args.applySnapshot(snapshot);
                    return this.keys.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith(arg1)).filter(x -> ((PreferenceKeyImpl)x.getValue()).canAccess(this.serviceCollection, user)).map(Map.Entry::getKey).collect(Collectors.toList());
                }
                return this.parseFirst((CommandSource)src, (CommandArgs)args, (CommandContext)context, (String)arg1).element.apply(this.serviceCollection).complete(src, args, context);
            }
            catch (ArgumentParseException e) {
                return ImmutableList.of();
            }
        }

        public Text getUsage(CommandSource src) {
            return this.getKey();
        }

        private static enum Type {
            BOOLEAN(new LazyLoadFunction<INucleusServiceCollection, CommandElement>(s -> GenericArguments.bool((Text)VALUE_ARG))),
            DOUBLE(new LazyLoadFunction<INucleusServiceCollection, CommandElement>(s -> GenericArguments.doubleNum((Text)VALUE_ARG))),
            INTEGER(new LazyLoadFunction<INucleusServiceCollection, CommandElement>(s -> GenericArguments.integer((Text)VALUE_ARG))),
            STRING(new LazyLoadFunction<INucleusServiceCollection, CommandElement>(s -> GenericArguments.remainingRawJoinedStrings((Text)VALUE_ARG))),
            LOCALE(new LazyLoadFunction<INucleusServiceCollection, CommandElement>(s -> s.commandElementSupplier().createLocaleElement(VALUE_ARG)));

            final LazyLoadFunction<INucleusServiceCollection, CommandElement> element;

            private Type(LazyLoadFunction<INucleusServiceCollection, CommandElement> element) {
                this.element = element;
            }
        }
    }
}

